/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.zrtp;

import gnu.java.zrtp.ZrtpCodes;
import gnu.java.zrtp.ZrtpUserCallback;
import java.util.EnumSet;
import java.util.Iterator;
import org.jitsi.impl.neomedia.transform.zrtp.ZrtpControlImpl;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.event.SrtpListener;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.Logger;

public class SecurityEventManager
extends ZrtpUserCallback {
    private static final Logger logger = Logger.getLogger(SecurityEventManager.class);
    public static final String WARNING_NO_RS_MATCH = SecurityEventManager.getI18NString("impl.media.security.WARNING_NO_RS_MATCH", null);
    public static final String WARNING_NO_EXPECTED_RS_MATCH = SecurityEventManager.getI18NString("impl.media.security.WARNING_NO_EXPECTED_RS_MATCH", null);
    private final ZrtpControlImpl zrtpControl;
    private SecurityEventManager masterEventManager;
    private SrtpListener securityListener;
    private MediaType sessionType;
    private String sas;
    private String cipher;
    private boolean isSasVerified;

    public SecurityEventManager(ZrtpControlImpl zrtpControl) {
        this.zrtpControl = zrtpControl;
        this.securityListener = zrtpControl.getSrtpListener();
    }

    public void setSessionType(MediaType sessionType) {
        this.sessionType = sessionType;
    }

    void setMasterEventManager(SecurityEventManager master) {
        this.masterEventManager = master;
    }

    public void secureOn(String cipher) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.sessionTypeToString(this.sessionType) + ": cipher enabled: " + cipher);
        }
        this.cipher = cipher;
    }

    public void showSAS(String sas, boolean isVerified) {
        if (logger.isDebugEnabled()) {
            logger.debug(this.sessionTypeToString(this.sessionType) + ": SAS is: " + sas);
        }
        this.sas = sas;
        this.isSasVerified = isVerified;
    }

    public void setSASVerified(boolean isVerified) {
        this.isSasVerified = this.getSecurityString() != null && isVerified;
    }

    public void showMessage(ZrtpCodes.MessageSeverity sev, EnumSet<?> subCode) {
        int multiStreams = 0;
        Iterator ii = subCode.iterator();
        Object msgCode = ii.next();
        String message = null;
        String i18nMessage = null;
        int severity = 0;
        boolean sendEvent = true;
        if (msgCode instanceof ZrtpCodes.InfoCodes) {
            ZrtpCodes.InfoCodes inf = (ZrtpCodes.InfoCodes)msgCode;
            sendEvent = false;
            if (inf == ZrtpCodes.InfoCodes.InfoSecureStateOn) {
                this.securityListener.securityTurnedOn(this.sessionType, this.cipher, this.zrtpControl);
            }
        } else if (msgCode instanceof ZrtpCodes.WarningCodes) {
            ZrtpCodes.WarningCodes warn = (ZrtpCodes.WarningCodes)msgCode;
            severity = 1;
            if (warn == ZrtpCodes.WarningCodes.WarningNoRSMatch) {
                message = "No retained shared secret available.";
                i18nMessage = WARNING_NO_RS_MATCH;
            } else if (warn == ZrtpCodes.WarningCodes.WarningNoExpectedRSMatch) {
                message = "An expected retained shared secret is missing.";
                i18nMessage = WARNING_NO_EXPECTED_RS_MATCH;
            } else if (warn == ZrtpCodes.WarningCodes.WarningCRCmismatch) {
                message = "Internal ZRTP packet checksum mismatch.";
                i18nMessage = SecurityEventManager.getI18NString("impl.media.security.CHECKSUM_MISMATCH", null);
            } else {
                sendEvent = false;
            }
        } else if (msgCode instanceof ZrtpCodes.SevereCodes) {
            ZrtpCodes.SevereCodes severe = (ZrtpCodes.SevereCodes)msgCode;
            severity = 2;
            if (severe == ZrtpCodes.SevereCodes.SevereCannotSend) {
                message = "Failed to send data.Internet data connection or peer is down.";
                i18nMessage = SecurityEventManager.getI18NString("impl.media.security.DATA_SEND_FAILED", msgCode.toString());
            } else if (severe == ZrtpCodes.SevereCodes.SevereTooMuchRetries) {
                message = "Too much retries during ZRTP negotiation.";
                i18nMessage = SecurityEventManager.getI18NString("impl.media.security.RETRY_RATE_EXCEEDED", msgCode.toString());
            } else if (severe == ZrtpCodes.SevereCodes.SevereProtocolError) {
                message = "Internal protocol error occured.";
                i18nMessage = SecurityEventManager.getI18NString("impl.media.security.INTERNAL_PROTOCOL_ERROR", msgCode.toString());
            } else {
                message = "General error has occurred.";
                i18nMessage = SecurityEventManager.getI18NString("impl.media.security.ZRTP_GENERIC_MSG", msgCode.toString());
            }
        } else if (msgCode instanceof ZrtpCodes.ZrtpErrorCodes) {
            severity = 3;
            message = "Indicates compatibility problems like for example:unsupported protocol version, unsupported hash type,cypher type, SAS scheme, etc.";
            i18nMessage = SecurityEventManager.getI18NString("impl.media.security.ZRTP_GENERIC_MSG", msgCode.toString());
        } else {
            sendEvent = false;
        }
        if (sendEvent) {
            this.securityListener.securityMessageReceived(message, i18nMessage, severity);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.sessionTypeToString(this.sessionType) + ": ZRTP message: severity: " + sev + ", sub code: " + msgCode + ", multi: " + multiStreams);
        }
    }

    public void zrtpNegotiationFailed(ZrtpCodes.MessageSeverity severity, EnumSet<?> subCode) {
        Iterator ii = subCode.iterator();
        Object msgCode = ii.next();
        if (logger.isDebugEnabled()) {
            logger.debug(this.sessionTypeToString(this.sessionType) + ": ZRTP key negotiation failed, sub code: " + msgCode);
        }
    }

    public void secureOff() {
        if (logger.isDebugEnabled()) {
            logger.debug(this.sessionTypeToString(this.sessionType) + ": Security off");
        }
        this.securityListener.securityTurnedOff(this.sessionType);
    }

    public void zrtpNotSuppOther() {
        if (logger.isDebugEnabled()) {
            logger.debug(this.sessionTypeToString(this.sessionType) + ": Other party does not support ZRTP key negotiation" + " protocol, no secure calls possible.");
        }
        this.securityListener.securityTimeout(this.sessionType);
    }

    public void confirmGoClear() {
        if (logger.isDebugEnabled()) {
            logger.debug(this.sessionTypeToString(this.sessionType) + ": GoClear confirmation requested.");
        }
    }

    private String sessionTypeToString(MediaType sessionType) {
        switch (sessionType) {
            case AUDIO: {
                return "AUDIO_SESSION";
            }
            case VIDEO: {
                return "VIDEO_SESSION";
            }
        }
        throw new IllegalArgumentException("sessionType");
    }

    private static String getI18NString(String key, String param) {
        String[] stringArray;
        ResourceManagementService resources = LibJitsi.getResourceManagementService();
        if (resources == null) {
            return null;
        }
        if (param == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = param;
        }
        String[] params = stringArray;
        return resources.getI18NString(key, params);
    }

    public void setSrtpListener(SrtpListener securityListener) {
        this.securityListener = securityListener;
    }

    public String getSecurityString() {
        if (this.masterEventManager != null && this.masterEventManager != this) {
            return this.masterEventManager.sas;
        }
        return this.sas;
    }

    public String getCipherString() {
        return this.cipher;
    }

    public boolean isSecurityVerified() {
        if (this.masterEventManager != null && this.masterEventManager != this) {
            return this.masterEventManager.isSasVerified;
        }
        return this.isSasVerified;
    }

    public void securityNegotiationStarted() {
        try {
            this.securityListener.securityNegotiationStarted(this.sessionType, this.zrtpControl);
        }
        catch (Throwable t) {
            logger.error("Error processing security started.");
        }
    }
}

