/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.transform.sdes;

import ch.imvs.sdes4j.srtp.SrtpCryptoAttribute;
import ch.imvs.sdes4j.srtp.SrtpCryptoSuite;
import ch.imvs.sdes4j.srtp.SrtpSessionParam;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTCPTransformer;
import org.jitsi.impl.neomedia.transform.srtp.SRTPContextFactory;
import org.jitsi.impl.neomedia.transform.srtp.SRTPPolicy;
import org.jitsi.impl.neomedia.transform.srtp.SRTPTransformer;
import org.jitsi.service.neomedia.SrtpControl;

public class SDesTransformEngine
implements SrtpControl.TransformEngine {
    private SRTPTransformer srtpTransformer;
    private SRTCPTransformer srtcpTransformer;
    private SrtpCryptoAttribute inAttribute;
    private SrtpCryptoAttribute outAttribute;
    private SRTPContextFactory reverseCtx;
    private SRTPContextFactory forwardCtx;

    public SDesTransformEngine(SrtpCryptoAttribute inAttribute, SrtpCryptoAttribute outAttribute) {
        this.update(inAttribute, outAttribute);
    }

    public void update(SrtpCryptoAttribute inAttribute, SrtpCryptoAttribute outAttribute) {
        boolean changed = false;
        if (!inAttribute.equals((Object)this.inAttribute)) {
            this.inAttribute = inAttribute;
            this.reverseCtx = SDesTransformEngine.getTransformEngine(inAttribute, false);
            changed = true;
        }
        if (!outAttribute.equals((Object)this.outAttribute)) {
            this.outAttribute = outAttribute;
            this.forwardCtx = SDesTransformEngine.getTransformEngine(outAttribute, true);
            changed = true;
        }
        if (changed) {
            if (this.srtpTransformer == null) {
                this.srtpTransformer = new SRTPTransformer(this.forwardCtx, this.reverseCtx);
            } else {
                this.srtpTransformer.setContextFactory(this.forwardCtx, true);
                this.srtpTransformer.setContextFactory(this.reverseCtx, false);
            }
            if (this.srtcpTransformer == null) {
                this.srtcpTransformer = new SRTCPTransformer(this.forwardCtx, this.reverseCtx);
            } else {
                this.srtcpTransformer.updateFactory(this.forwardCtx, true);
                this.srtcpTransformer.updateFactory(this.reverseCtx, false);
            }
        }
    }

    @Override
    public void cleanup() {
        if (this.srtpTransformer != null) {
            this.srtpTransformer.close();
        }
        if (this.srtcpTransformer != null) {
            this.srtcpTransformer.close();
        }
        this.srtpTransformer = null;
        this.srtcpTransformer = null;
    }

    private static SRTPContextFactory getTransformEngine(SrtpCryptoAttribute attribute, boolean sender) {
        SrtpSessionParam[] sessionParams = attribute.getSessionParams();
        if (sessionParams != null && sessionParams.length > 0) {
            throw new IllegalArgumentException("session parameters are not supported");
        }
        SrtpCryptoSuite cryptoSuite = attribute.getCryptoSuite();
        return new SRTPContextFactory(sender, SDesTransformEngine.getKey(attribute), SDesTransformEngine.getSalt(attribute), new SRTPPolicy(SDesTransformEngine.getEncryptionCipher(cryptoSuite), cryptoSuite.getEncKeyLength() / 8, SDesTransformEngine.getHashAlgorithm(cryptoSuite), cryptoSuite.getSrtpAuthKeyLength() / 8, cryptoSuite.getSrtpAuthTagLength() / 8, cryptoSuite.getSaltKeyLength() / 8), new SRTPPolicy(SDesTransformEngine.getEncryptionCipher(cryptoSuite), cryptoSuite.getEncKeyLength() / 8, SDesTransformEngine.getHashAlgorithm(cryptoSuite), cryptoSuite.getSrtcpAuthKeyLength() / 8, cryptoSuite.getSrtcpAuthTagLength() / 8, cryptoSuite.getSaltKeyLength() / 8));
    }

    private static byte[] getKey(SrtpCryptoAttribute attribute) {
        int length = attribute.getCryptoSuite().getEncKeyLength() / 8;
        byte[] key = new byte[length];
        System.arraycopy(attribute.getKeyParams()[0].getKey(), 0, key, 0, length);
        return key;
    }

    private static byte[] getSalt(SrtpCryptoAttribute attribute) {
        int keyLength = attribute.getCryptoSuite().getEncKeyLength() / 8;
        int saltLength = attribute.getCryptoSuite().getSaltKeyLength() / 8;
        byte[] salt = new byte[keyLength];
        System.arraycopy(attribute.getKeyParams()[0].getKey(), keyLength, salt, 0, saltLength);
        return salt;
    }

    private static int getEncryptionCipher(SrtpCryptoSuite cs) {
        switch (cs.getEncryptionAlgorithm()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalArgumentException("Unsupported cipher");
    }

    private static int getHashAlgorithm(SrtpCryptoSuite cs) {
        switch (cs.getHashAlgorithm()) {
            case 1: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unsupported hash");
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return this.srtpTransformer;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this.srtcpTransformer;
    }
}

