/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.codec.video.ByteBuffer;

public class AVFrame {
    private ByteBuffer data;
    private boolean free;
    private long ptr;

    public static int read(Buffer buffer, Format format, ByteBuffer data) {
        AVFrame frame;
        AVFrameFormat frameFormat = (AVFrameFormat)format;
        Object o = buffer.getData();
        if (o instanceof AVFrame) {
            frame = (AVFrame)o;
        } else {
            frame = new AVFrame();
            buffer.setData(frame);
        }
        return frame.avpicture_fill(data, frameFormat);
    }

    public AVFrame() {
        this.ptr = FFmpeg.avcodec_alloc_frame();
        if (this.ptr == 0L) {
            throw new OutOfMemoryError("avcodec_alloc_frame()");
        }
        this.free = true;
    }

    public AVFrame(long ptr) {
        if (ptr == 0L) {
            throw new IllegalArgumentException("ptr");
        }
        this.ptr = ptr;
        this.free = false;
    }

    public synchronized int avpicture_fill(ByteBuffer data, AVFrameFormat format) {
        Dimension size = format.getSize();
        int ret = FFmpeg.avpicture_fill(this.ptr, data.getPtr(), format.getPixFmt(), size.width, size.height);
        if (ret >= 0) {
            if (this.data != null) {
                this.data.free();
            }
            this.data = data;
        }
        return ret;
    }

    protected void finalize() throws Throwable {
        try {
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized void free() {
        if (this.free && this.ptr != 0L) {
            FFmpeg.avcodec_free_frame(this.ptr);
            this.free = false;
            this.ptr = 0L;
        }
        if (this.data != null) {
            this.data.free();
            this.data = null;
        }
    }

    public synchronized ByteBuffer getData() {
        return this.data;
    }

    public synchronized long getPtr() {
        return this.ptr;
    }
}

