/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.amrwb;

import javax.media.Buffer;
import javax.media.Format;
import org.jitsi.impl.neomedia.codec.audio.FFmpegAudioDecoder;
import org.jitsi.impl.neomedia.codec.audio.amrwb.JNIEncoder;

public class JNIDecoder
extends FFmpegAudioDecoder {
    private boolean depacketize = false;

    public JNIDecoder() {
        super("AMR-WB JNI Decoder", 73729, (Format[])JNIEncoder.SUPPORTED_INPUT_FORMATS);
        this.inputFormats = JNIEncoder.SUPPORTED_OUTPUT_FORMATS;
    }

    private int depacketize(Buffer buf) {
        int inOff;
        int inLen = buf.getLength();
        if (inLen < 2) {
            return 1;
        }
        byte[] in = (byte[])buf.getData();
        int in0 = in[inOff = buf.getOffset()] & 0xFF;
        int f = (8 & in0) >>> 3;
        if (f == 1) {
            return 1;
        }
        int in1 = in[inOff + 1] & 0xFF;
        int q = (0x40 & in1) >>> 6;
        if (q == 0) {
            return 1;
        }
        int ft = (7 & in0) << 1 | (0x80 & in1) >>> 7;
        if (ft > 8) {
            return 4;
        }
        int outLen = inLen;
        byte[] out = in;
        int out0 = (ft & 0xF) << 3 | (q & 1) << 2;
        out[0] = (byte)out0;
        int inI = inOff + 1;
        int inEnd = inOff + inLen;
        int outI = 1;
        while (inI < inEnd) {
            int i = (0x3F & in[inI]) << 2;
            out[outI] = (byte)i;
            if (++inI < inEnd) {
                int o = 0xFC & out[outI];
                i = (0xC0 & in[inI]) >>> 6;
                out[outI] = (byte)(o | i);
            }
            ++outI;
        }
        buf.setData(out);
        buf.setDuration(20000000L);
        buf.setLength(outLen);
        buf.setOffset(0);
        return 0;
    }

    @Override
    protected int doProcess(Buffer inBuf, Buffer outBuf) {
        int depacketize;
        if (this.depacketize && (((depacketize = this.depacketize(inBuf)) & 1) != 0 || (depacketize & 4) != 0)) {
            return depacketize;
        }
        return super.doProcess(inBuf, outBuf);
    }

    @Override
    public Format setInputFormat(Format format) {
        if ((format = super.setInputFormat(format)) != null) {
            String encoding = format.getEncoding();
            this.depacketize = encoding != null && encoding.endsWith("/rtp");
        }
        return format;
    }

    static {
        JNIDecoder.assertFindAVCodec(73729);
    }
}

