/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Socket;
import org.ice4j.socket.MultiplexingSocket;
import org.jitsi.impl.neomedia.transform.TransformInputStream;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.packetlogging.PacketLoggingService;
import org.jitsi.util.Logger;

public class RTPConnectorTCPInputStream
extends TransformInputStream<Socket> {
    private static final Logger logger = Logger.getLogger(RTPConnectorTCPInputStream.class);

    public RTPConnectorTCPInputStream(Socket socket) {
        super(socket);
    }

    @Override
    protected void doLogPacket(DatagramPacket p) {
        if (((Socket)this.socket).getLocalAddress() == null) {
            return;
        }
        if (this.socket instanceof MultiplexingSocket) {
            return;
        }
        PacketLoggingService packetLogging = LibJitsi.getPacketLoggingService();
        if (packetLogging != null) {
            byte[] byArray;
            if (p.getAddress() != null) {
                byArray = p.getAddress().getAddress();
            } else {
                byte[] byArray2 = new byte[4];
                byArray2[0] = 0;
                byArray2[1] = 0;
                byArray2[2] = 0;
                byArray = byArray2;
                byArray2[3] = 0;
            }
            packetLogging.logPacket(PacketLoggingService.ProtocolName.RTP, byArray, p.getPort(), ((Socket)this.socket).getLocalAddress().getAddress(), ((Socket)this.socket).getLocalPort(), PacketLoggingService.TransportName.TCP, false, p.getData(), p.getOffset(), p.getLength());
        }
    }

    @Override
    protected void receive(DatagramPacket p) throws IOException {
        int len;
        byte[] data;
        try {
            data = p.getData();
            len = ((Socket)this.socket).getInputStream().read(data);
        }
        catch (Exception e) {
            data = null;
            len = -1;
            logger.info("problem read: " + e);
        }
        if (len <= 0) {
            throw new IOException("Failed to read on TCP socket");
        }
        p.setData(data);
        p.setLength(len);
        p.setAddress(((Socket)this.socket).getInetAddress());
        p.setPort(((Socket)this.socket).getPort());
    }

    @Override
    protected void setReceiveBufferSize(int receiveBufferSize) throws IOException {
        ((Socket)this.socket).setReceiveBufferSize(receiveBufferSize);
    }
}

