/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.fileaccess;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jitsi.service.fileaccess.FailSafeTransaction;

public class FailSafeTransactionImpl
implements FailSafeTransaction {
    private File file;
    private File backup;
    private static final String PART_EXT = ".part";
    private static final String BAK_EXT = ".bak";

    protected FailSafeTransactionImpl(File file) throws NullPointerException {
        if (file == null) {
            throw new NullPointerException("null file provided");
        }
        this.file = file;
        this.backup = null;
    }

    @Override
    public void restoreFile() throws IllegalStateException, IOException {
        File back = new File(this.file.getAbsolutePath() + BAK_EXT);
        if (back.exists()) {
            this.failsafeCopy(back.getAbsolutePath(), this.file.getAbsolutePath());
            back.delete();
        }
    }

    @Override
    public void beginTransaction() throws IllegalStateException, IOException {
        if (this.backup != null) {
            this.commit();
        }
        this.restoreFile();
        this.backup = new File(this.file.getAbsolutePath() + BAK_EXT);
        this.failsafeCopy(this.file.getAbsolutePath(), this.backup.getAbsolutePath());
    }

    @Override
    public void commit() throws IllegalStateException, IOException {
        if (this.backup == null) {
            return;
        }
        this.backup.delete();
        this.backup = null;
    }

    @Override
    public void rollback() throws IllegalStateException, IOException {
        if (this.backup == null) {
            return;
        }
        this.failsafeCopy(this.backup.getAbsolutePath(), this.file.getAbsolutePath());
        this.backup.delete();
        this.backup = null;
    }

    private void failsafeCopy(String from, String to) throws IllegalStateException, IOException {
        int len;
        FileInputStream in = null;
        FileOutputStream out = null;
        File toF = new File(to);
        if (toF.exists() && !toF.delete()) {
            throw new IOException("Failed to delete destination file: " + toF.getName());
        }
        File ptoF = new File(to + PART_EXT);
        if (ptoF.exists() && !ptoF.delete()) {
            throw new IOException("Failed to delete partial file: " + ptoF.getName());
        }
        try {
            in = new FileInputStream(from);
            out = new FileOutputStream(to + PART_EXT);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
        if (!ptoF.renameTo(toF)) {
            throw new IOException("Failed to rename " + ptoF.getName() + " to" + toF.getName());
        }
    }
}

