/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.DataOutputStream;
import java.io.IOException;
import net.sf.fmj.media.rtp.RTCPPacket;

public class RTCPBYEPacket
extends RTCPPacket {
    int[] ssrc;
    byte[] reason;

    public RTCPBYEPacket(int[] ssrc, byte[] reason) {
        if (ssrc.length > 31) {
            throw new IllegalArgumentException("Too many SSRCs");
        }
        this.ssrc = ssrc;
        this.reason = reason == null ? new byte[]{} : reason;
    }

    public RTCPBYEPacket(RTCPPacket parent) {
        super(parent);
        this.type = 203;
    }

    public void assemble(DataOutputStream out) throws IOException {
        int i;
        out.writeByte(128 + this.ssrc.length);
        out.writeByte(203);
        out.writeShort(this.ssrc.length + (this.reason.length <= 0 ? 0 : this.reason.length + 4 >> 2));
        for (i = 0; i < this.ssrc.length; ++i) {
            out.writeInt(this.ssrc[i]);
        }
        if (this.reason.length > 0) {
            out.writeByte(this.reason.length);
            out.write(this.reason);
            for (i = (this.reason.length + 4 & 0xFFFFFFFC) - this.reason.length - 1; i > 0; --i) {
                out.writeByte(0);
            }
        }
    }

    public int calcLength() {
        return 4 + (this.ssrc.length << 2) + (this.reason.length <= 0 ? 0 : this.reason.length + 4 & 0xFFFFFFFC);
    }

    public String toString() {
        return "\tRTCP BYE packet for sync source(s) " + this.toString(this.ssrc) + " for " + (this.reason.length <= 0 ? "no reason" : "reason " + new String(this.reason)) + "\n";
    }

    public String toString(int[] ints) {
        if (ints.length == 0) {
            return "(none)";
        }
        String s = "" + ints[0];
        for (int i = 1; i < ints.length; ++i) {
            s = s + ", " + ints[i];
        }
        return s;
    }
}

