/*
 * Decompiled with CFR 0.152.
 */
package javax.media;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import net.sf.fmj.utility.LoggerSingleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaptureDeviceManager {
    private static final Logger logger = LoggerSingleton.logger;
    private static Class<?> implClass;
    private static Method getDeviceMethod;
    private static Method getDeviceListMethod;
    private static Method addDeviceMethod;
    private static Method removeDeviceMethod;
    private static Method commitMethod;

    public static boolean addDevice(CaptureDeviceInfo newDevice) {
        if (!CaptureDeviceManager.init()) {
            return false;
        }
        return (Boolean)CaptureDeviceManager.callImpl(addDeviceMethod, new Object[]{newDevice});
    }

    private static Object callImpl(Method method, Object[] args) {
        try {
            return method.invoke(null, args);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        catch (InvocationTargetException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
    }

    public static void commit() throws IOException {
        if (!CaptureDeviceManager.init()) {
            return;
        }
        Method method = commitMethod;
        Object[] args = new Object[]{};
        try {
            method.invoke(null, args);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.WARNING, "" + e, e);
            return;
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "" + e, e);
            return;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            logger.log(Level.WARNING, "" + e, e);
            return;
        }
    }

    public static CaptureDeviceInfo getDevice(String deviceName) {
        if (!CaptureDeviceManager.init()) {
            return null;
        }
        return (CaptureDeviceInfo)CaptureDeviceManager.callImpl(getDeviceMethod, new Object[]{deviceName});
    }

    public static Vector getDeviceList(Format format) {
        if (!CaptureDeviceManager.init()) {
            return null;
        }
        return (Vector)CaptureDeviceManager.callImpl(getDeviceListMethod, new Object[]{format});
    }

    private static Method getStaticMethodOnImplClass(String name, Class<?>[] args, Class<?> returnType) throws Exception {
        Method m = implClass.getMethod(name, args);
        if (m.getReturnType() != returnType) {
            throw new Exception("Expected return type of method " + name + " to be " + returnType + ", was " + m.getReturnType());
        }
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new Exception("Expected method " + name + " to be static");
        }
        return m;
    }

    private static synchronized boolean init() {
        if (implClass != null) {
            return true;
        }
        try {
            implClass = Class.forName("javax.media.cdm.CaptureDeviceManager");
            if (!CaptureDeviceManager.class.isAssignableFrom(implClass)) {
                throw new Exception("javax.media.cdm.CaptureDeviceManager not subclass of " + CaptureDeviceManager.class.getName());
            }
            getDeviceMethod = CaptureDeviceManager.getStaticMethodOnImplClass("getDevice", new Class[]{String.class}, CaptureDeviceInfo.class);
            getDeviceListMethod = CaptureDeviceManager.getStaticMethodOnImplClass("getDeviceList", new Class[]{Format.class}, Vector.class);
            addDeviceMethod = CaptureDeviceManager.getStaticMethodOnImplClass("addDevice", new Class[]{CaptureDeviceInfo.class}, Boolean.TYPE);
            removeDeviceMethod = CaptureDeviceManager.getStaticMethodOnImplClass("removeDevice", new Class[]{CaptureDeviceInfo.class}, Boolean.TYPE);
            commitMethod = CaptureDeviceManager.getStaticMethodOnImplClass("commit", new Class[0], Void.TYPE);
        }
        catch (Exception e) {
            implClass = null;
            logger.log(Level.WARNING, "" + e, e);
            return false;
        }
        return true;
    }

    public static boolean removeDevice(CaptureDeviceInfo device) {
        if (!CaptureDeviceManager.init()) {
            return false;
        }
        return (Boolean)CaptureDeviceManager.callImpl(removeDeviceMethod, new Object[]{device});
    }
}

