/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cryptozrtp.generators;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import org.bouncycastle.crypto.prng.RandomGenerator;

class DHKeyGeneratorHelper {
    private static final int MAX_ITERATIONS = 1000;
    static final DHKeyGeneratorHelper INSTANCE = new DHKeyGeneratorHelper();
    private static final BigIntegerCrypto ZERO = BigIntegerCrypto.valueOf(0L);
    private static final BigIntegerCrypto TWO = BigIntegerCrypto.valueOf(2L);

    private DHKeyGeneratorHelper() {
    }

    BigIntegerCrypto calculatePrivate(BigIntegerCrypto p, RandomGenerator random, int limit) {
        BigIntegerCrypto x;
        BigIntegerCrypto pSub2 = p.subtract(TWO);
        if (limit == 0) {
            x = this.createInRange(pSub2, random);
        } else {
            while ((x = new BigIntegerCrypto(limit, 0, random)).equals(ZERO)) {
            }
        }
        return x;
    }

    private BigIntegerCrypto createInRange(BigIntegerCrypto max, RandomGenerator random) {
        BigIntegerCrypto x;
        int maxLength = max.bitLength();
        int count = 0;
        while (((x = new BigIntegerCrypto(maxLength, random)).equals(ZERO) || x.compareTo(max) > 0) && ++count != 1000) {
        }
        if (count == 1000) {
            return new BigIntegerCrypto(maxLength - 1, random).setBit(0);
        }
        return x;
    }

    BigIntegerCrypto calculatePublic(BigIntegerCrypto p, BigIntegerCrypto g, BigIntegerCrypto x) {
        return g.modPow(x, p);
    }
}

