/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class IOUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        IOUtils.copyStream(fileInputStream, fileOutputStream);
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public static void copyFile(String string, String string2) throws IOException {
        IOUtils.copyFile(new File(string), new File(string2));
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[2048];
        int n;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        return;
    }

    public static byte[] readAll(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copyStream(inputStream, byteArrayOutputStream);
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static String readAll(Reader reader) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = reader.read()) != -1) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public static String readAllToString(InputStream inputStream) throws IOException {
        byte[] byArray = IOUtils.readAll(inputStream);
        return new String(byArray);
    }

    public static String readAllToString(InputStream inputStream, String string) throws IOException {
        byte[] byArray = IOUtils.readAll(inputStream);
        return new String(byArray, string);
    }

    public static void readAllToStringBuffer(InputStream inputStream, String string, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append(IOUtils.readAllToString(inputStream, string));
    }

    public static void readAllToStringBuffer(InputStream inputStream, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append(IOUtils.readAllToString(inputStream));
    }

    public static void readAllToStringBuilder(InputStream inputStream, String string, StringBuilder stringBuilder) throws IOException {
        stringBuilder.append(IOUtils.readAllToString(inputStream, string));
    }

    public static void readAllToStringBuilder(InputStream inputStream, StringBuilder stringBuilder) throws IOException {
        stringBuilder.append(IOUtils.readAllToString(inputStream));
    }

    public static void writeStringToFile(String string, String string2) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        fileOutputStream.write(string.getBytes());
        fileOutputStream.close();
    }

    private IOUtils() {
    }
}

