/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.utility;

import java.util.Vector;
import java.util.logging.Logger;
import javax.media.Manager;
import javax.media.PackageManager;
import net.sf.fmj.utility.LoggerSingleton;

public final class ClasspathChecker {
    private static final Logger logger = LoggerSingleton.logger;

    public static boolean check() {
        boolean bl = true;
        if (!ClasspathChecker.checkFMJPrefixInPackageManager()) {
            bl = false;
        }
        if (!ClasspathChecker.checkManagerImplementation()) {
            bl = false;
        }
        return bl;
    }

    public static boolean checkAndWarn() {
        boolean bl = true;
        if (!ClasspathChecker.checkFMJPrefixInPackageManager()) {
            logger.warning("net.sf.fmj not found in PackageManager.getContentPrefixList() and PackageManager.getProtocolPrefixList(); is JMF ahead of FMJ in the classpath?");
            bl = false;
        }
        if (ClasspathChecker.checkJMFInClassPath()) {
            logger.info("JMF detected in classpath");
        }
        if (!ClasspathChecker.checkManagerImplementation()) {
            logger.warning("javax.media.Manager is JMF's implementation, not FMJ's; is JMF ahead of FMJ in the classpath?");
            bl = false;
        }
        logger.info("javax.media.Manager version: " + Manager.getVersion());
        return bl;
    }

    public static boolean checkFMJPrefixInPackageManager() {
        Vector vector = PackageManager.getContentPrefixList();
        if (!vector.contains("net.sf.fmj")) {
            return false;
        }
        Vector vector2 = PackageManager.getProtocolPrefixList();
        return vector2.contains("net.sf.fmj");
    }

    public static boolean checkJMFInClassPath() {
        try {
            Class.forName("com.sun.media.BasicClock");
            Class.forName("com.sun.media.BasicCodec");
            Class.forName("com.sun.media.BasicConnector");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean checkManagerImplementation() {
        try {
            Manager.class.getField("FMJ_TAG");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

