/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.renderer.video;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.ImageInputStream;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.Owned;
import javax.media.control.FrameRateControl;
import javax.media.format.VideoFormat;
import javax.media.renderer.VideoRenderer;
import net.sf.fmj.media.AbstractVideoRenderer;
import net.sf.fmj.media.codec.video.jpeg.RFC2035;
import net.sf.fmj.media.renderer.video.JVideoComponent;
import net.sf.fmj.utility.ArrayUtility;
import net.sf.fmj.utility.LoggerSingleton;

public class JPEGRTPRenderer
extends AbstractVideoRenderer
implements VideoRenderer {
    private static final Logger logger = LoggerSingleton.logger;
    private static final boolean TRACE = true;
    private final Format[] supportedInputFormats = new Format[]{new VideoFormat("jpeg/rtp", null, -1, Format.byteArray, -1.0f)};
    private JVideoComponent component = new JVideoComponent();
    private JPEGRTPFrame currentFrame;
    private ImageReader decoder;
    private JPEGImageReadParam param;
    private JPEGHuffmanTable[] huffmanDCTables;
    private JPEGHuffmanTable[] huffmanACTables;
    private JPEGQTable[] qtable;
    private int quality = -1;
    private float frameRate = -1.0f;
    private int framesProcessed;
    private long lastTimestamp;
    private BufferedImage itsImage;

    public JPEGRTPRenderer() {
        this.addControl(this);
        this.addControl(new VideoFrameRateControl());
    }

    public void close() {
        if (null != this.decoder) {
            this.decoder.dispose();
        }
    }

    private JPEGHuffmanTable[] createACHuffmanTables() {
        JPEGHuffmanTable jPEGHuffmanTable = new JPEGHuffmanTable(RFC2035.chm_ac_codelens, RFC2035.chm_ac_symbols);
        JPEGHuffmanTable jPEGHuffmanTable2 = new JPEGHuffmanTable(RFC2035.lum_ac_codelens, RFC2035.lum_ac_symbols);
        JPEGHuffmanTable[] jPEGHuffmanTableArray = new JPEGHuffmanTable[]{jPEGHuffmanTable2, jPEGHuffmanTable};
        return jPEGHuffmanTableArray;
    }

    private JPEGHuffmanTable[] createDCHuffmanTables() {
        JPEGHuffmanTable jPEGHuffmanTable = new JPEGHuffmanTable(RFC2035.chm_dc_codelens, RFC2035.chm_dc_symbols);
        JPEGHuffmanTable jPEGHuffmanTable2 = new JPEGHuffmanTable(RFC2035.lum_dc_codelens, RFC2035.lum_dc_symbols);
        JPEGHuffmanTable[] jPEGHuffmanTableArray = new JPEGHuffmanTable[]{jPEGHuffmanTable2, jPEGHuffmanTable};
        return jPEGHuffmanTableArray;
    }

    private JPEGQTable[] createQTable(int n) {
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        RFC2035.MakeTables(n, byArray, byArray2, RFC2035.jpeg_luma_quantizer_normal, RFC2035.jpeg_chroma_quantizer_normal);
        JPEGQTable jPEGQTable = new JPEGQTable(ArrayUtility.byteArrayToIntArray(byArray));
        JPEGQTable jPEGQTable2 = new JPEGQTable(ArrayUtility.byteArrayToIntArray(byArray2));
        JPEGQTable[] jPEGQTableArray = new JPEGQTable[]{jPEGQTable, jPEGQTable2};
        return jPEGQTableArray;
    }

    public int doProcess(Buffer buffer) {
        long l = buffer.getTimeStamp();
        if (null == this.currentFrame) {
            this.currentFrame = new JPEGRTPFrame(l);
        }
        if (l < this.currentFrame.timestamp) {
            logger.fine("JPEGRTPRenderer: dropping packet ts=" + l);
        } else if (l > this.currentFrame.timestamp) {
            logger.fine("JPEGRTPRenderer: dropping current frame ts=" + this.currentFrame.timestamp + ", got new packet ts=" + l);
            this.currentFrame.clear(l);
            this.currentFrame.add(buffer);
        } else {
            this.currentFrame.add(buffer);
        }
        if (this.currentFrame.isComplete()) {
            byte[] byArray = this.currentFrame.getData();
            this.currentFrame = null;
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                this.decoder.setInput(imageInputStream, false, false);
                this.param.setDestination(this.itsImage);
                this.decoder.read(0, this.param);
                this.component.setImage(this.itsImage);
                imageInputStream.close();
                byteArrayInputStream.close();
                long l2 = System.nanoTime();
                if (-1L == this.lastTimestamp) {
                    this.lastTimestamp = l2;
                }
                ++this.framesProcessed;
                if (l2 - this.lastTimestamp > 1000000000L) {
                    float f = (float)(l2 - this.lastTimestamp) / 1000000.0f;
                    this.frameRate = (float)this.framesProcessed * (1000.0f / f);
                    this.framesProcessed = 0;
                    this.lastTimestamp = l2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return 0;
    }

    private void dump(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            String string = "";
            for (int i = 0; i < 16; ++i) {
                String string2 = Integer.toHexString(byArray[n2++] & 0xFF);
                string = string + (string2.length() < 2 ? "0" + string2 : string2);
                string = string + " ";
                if (n2 >= n) break;
            }
            System.out.println(string);
        }
        System.out.println(" ");
    }

    public Component getComponent() {
        return this.component;
    }

    public String getName() {
        return "JPEG/RTP Renderer";
    }

    public Format[] getSupportedInputFormats() {
        return this.supportedInputFormats;
    }

    private void initDecoder(int n) {
        if (null != this.decoder) {
            this.decoder.dispose();
        }
        this.decoder = ImageIO.getImageReadersByFormatName("JPEG").next();
        this.param = new JPEGImageReadParam();
        this.huffmanACTables = this.createACHuffmanTables();
        this.huffmanDCTables = this.createDCHuffmanTables();
        this.qtable = this.createQTable(n);
        this.param.setDecodeTables(this.qtable, this.huffmanDCTables, this.huffmanACTables);
    }

    public Format setInputFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)super.setInputFormat(format);
        if (videoFormat != null) {
            this.getComponent().setPreferredSize(videoFormat.getSize());
        }
        return videoFormat;
    }

    private class VideoFrameRateControl
    implements FrameRateControl,
    Owned {
        private VideoFrameRateControl() {
        }

        public Component getControlComponent() {
            return null;
        }

        public float getFrameRate() {
            return JPEGRTPRenderer.this.frameRate;
        }

        public float getMaxSupportedFrameRate() {
            return -1.0f;
        }

        public Object getOwner() {
            return JPEGRTPRenderer.this;
        }

        public float getPreferredFrameRate() {
            return -1.0f;
        }

        public float setFrameRate(float f) {
            return -1.0f;
        }
    }

    private class JPEGRTPFrame {
        public JPEGRTPFrame firstItem;
        public long timestamp;
        public boolean hasRTPMarker;
        public int count;
        public int dataLength;
        public JPEGRTPFrame nextItem;
        public Buffer itemData;
        public long fragmentOffset;
        byte[] jpegHeader = new byte[]{-1, -40, -1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 2, 0, 0, 1, 0, 1, 0, 0, -1, -64, 0, 17, 8, 0, -112, 0, -80, 3, 1, 34, 0, 2, 17, 1, 3, 17, 1, -1, -38, 0, 12, 3, 1, 0, 2, 17, 3, 17, 0, 63, 0};

        public JPEGRTPFrame(Buffer buffer) {
            this.itemData = buffer;
        }

        public JPEGRTPFrame(long l) {
            this.timestamp = l;
        }

        public void add(Buffer buffer) {
            Object object;
            JPEGRTPFrame jPEGRTPFrame = new JPEGRTPFrame((Buffer)buffer.clone());
            if ((buffer.getFlags() & 0x800) > 0) {
                this.hasRTPMarker = true;
            }
            ++this.count;
            if (null == this.firstItem) {
                this.firstItem = jPEGRTPFrame;
            } else {
                object = this.firstItem;
                while (((JPEGRTPFrame)object).nextItem != null) {
                    object = ((JPEGRTPFrame)object).nextItem;
                }
                ((JPEGRTPFrame)object).nextItem = jPEGRTPFrame;
            }
            object = (byte[])buffer.getData();
            jPEGRTPFrame.fragmentOffset = 0L;
            for (int i = 0; i < 3; ++i) {
                jPEGRTPFrame.fragmentOffset <<= 8;
                jPEGRTPFrame.fragmentOffset += (long)(object[i + 13] & 0xFF);
            }
        }

        public void clear(long l) {
            this.firstItem = null;
            this.timestamp = l;
            this.hasRTPMarker = false;
            this.count = 0;
            this.dataLength = 0;
        }

        public byte[] getData() {
            byte[] byArray = new byte[this.jpegHeader.length + this.dataLength + 2];
            System.arraycopy(this.jpegHeader, 0, byArray, 0, this.jpegHeader.length);
            JPEGRTPFrame jPEGRTPFrame = this.firstItem;
            long l = 0L;
            int n = this.jpegHeader.length;
            while (jPEGRTPFrame != null) {
                jPEGRTPFrame = this.firstItem;
                while (jPEGRTPFrame != null && jPEGRTPFrame.fragmentOffset != l) {
                    jPEGRTPFrame = jPEGRTPFrame.nextItem;
                }
                if (null == jPEGRTPFrame) continue;
                int n2 = jPEGRTPFrame.itemData.getLength() - 8;
                byte[] byArray2 = (byte[])jPEGRTPFrame.itemData.getData();
                System.arraycopy(byArray2, jPEGRTPFrame.itemData.getOffset() + 8, byArray, n, n2);
                n += n2;
                l += (long)n2;
            }
            byte[] byArray3 = (byte[])this.firstItem.itemData.getData();
            int n3 = byArray3[this.firstItem.itemData.getOffset() + 6] << 3;
            int n4 = byArray3[this.firstItem.itemData.getOffset() + 7] << 3;
            byArray[25] = (byte)(n4 >> 8 & 0xFF);
            byArray[26] = (byte)(n4 & 0xFF);
            byArray[27] = (byte)(n3 >> 8 & 0xFF);
            byArray[28] = (byte)(n3 & 0xFF);
            byArray[byArray.length - 2] = -1;
            byArray[byArray.length - 1] = -39;
            byte by = byArray3[this.firstItem.itemData.getOffset() + 5];
            if (null == JPEGRTPRenderer.this.decoder) {
                JPEGRTPRenderer.this.initDecoder(by);
            }
            if (JPEGRTPRenderer.this.quality != -1 && by != JPEGRTPRenderer.this.quality) {
                JPEGRTPRenderer.this.initDecoder(by);
            }
            JPEGRTPRenderer.this.quality = by;
            if (null == JPEGRTPRenderer.this.itsImage) {
                JPEGRTPRenderer.this.itsImage = new BufferedImage(n3, n4, 1);
            }
            return byArray;
        }

        public boolean isComplete() {
            if (this.hasRTPMarker) {
                JPEGRTPFrame jPEGRTPFrame = this.firstItem;
                long l = 0L;
                this.dataLength = 0;
                while (jPEGRTPFrame != null) {
                    jPEGRTPFrame = this.firstItem;
                    while (jPEGRTPFrame != null && jPEGRTPFrame.fragmentOffset != l) {
                        jPEGRTPFrame = jPEGRTPFrame.nextItem;
                    }
                    if (null == jPEGRTPFrame) continue;
                    int n = jPEGRTPFrame.itemData.getLength() - 8;
                    this.dataLength += n;
                    if ((jPEGRTPFrame.itemData.getFlags() & 0x800) > 0) {
                        return true;
                    }
                    l += (long)n;
                }
            }
            return false;
        }
    }
}

