/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriStatsExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Statistics {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<String, Object> stats = new HashMap<String, Object>();

    public static ColibriStatsExtension toXMPP(Statistics statistics) {
        ColibriStatsExtension ext = new ColibriStatsExtension();
        for (Map.Entry<String, Object> e : statistics.getStats().entrySet()) {
            ext.addStat(new ColibriStatsExtension.Stat(e.getKey(), e.getValue()));
        }
        return ext;
    }

    public abstract void generate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getStat(String stat) {
        Object value;
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            value = this.stats.get(stat);
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getStats() {
        HashMap<String, Object> stats;
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            stats = new HashMap<String, Object>(this.stats);
            Object var4_3 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            lock.unlock();
            throw throwable;
        }
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStat(String stat, Object value) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.unlockedSetStat(stat, value);
            Object var5_4 = null;
            lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, Object> e : this.getStats().entrySet()) {
            s.append(e.getKey()).append(":").append(e.getValue()).append("\n");
        }
        return s.toString();
    }

    protected void unlockedSetStat(String stat, Object value) {
        if (value == null) {
            this.stats.remove(stat);
        } else {
            this.stats.put(stat, value);
        }
    }
}

