/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.format.MediaFormat;

public abstract class AbstractMediaStream
implements MediaStream {
    private String name;
    private final Map<String, Object> properties = Collections.synchronizedMap(new HashMap());
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void assertDirection(MediaDirection direction, MediaDirection deviceDirection, String illegalArgumentExceptionMessage) throws IllegalArgumentException {
        if (direction != null && !direction.and(deviceDirection).equals((Object)direction)) {
            throw new IllegalArgumentException(illegalArgumentExceptionMessage);
        }
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(property, oldValue, newValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    protected void handleAttributes(MediaFormat format, Map<String, String> attrs) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setProperty(String propertyName, Object value) {
        if (value == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, value);
        }
    }
}

