/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtp.translator;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.media.protocol.DataSource;
import javax.media.rtp.Participant;
import javax.media.rtp.SendStream;
import javax.media.rtp.TransmissionStats;
import javax.media.rtp.rtcp.SenderReport;
import javax.media.rtp.rtcp.SourceDescription;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.translator.SendStreamDesc;

class SendStreamImpl
implements SendStream {
    private boolean closed;
    public final SendStreamDesc sendStreamDesc;
    private boolean started;
    public final StreamRTPManager streamRTPManager;

    public SendStreamImpl(StreamRTPManager streamRTPManager, SendStreamDesc sendStreamDesc) {
        this.sendStreamDesc = sendStreamDesc;
        this.streamRTPManager = streamRTPManager;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                if (this.started) {
                    this.stop();
                }
            }
            catch (IOException ioe) {
                throw new UndeclaredThrowableException(ioe);
            }
            finally {
                this.sendStreamDesc.close(this);
                this.closed = true;
            }
        }
    }

    @Override
    public DataSource getDataSource() {
        return this.sendStreamDesc.sendStream.getDataSource();
    }

    @Override
    public Participant getParticipant() {
        return this.sendStreamDesc.sendStream.getParticipant();
    }

    @Override
    public SenderReport getSenderReport() {
        return this.sendStreamDesc.sendStream.getSenderReport();
    }

    @Override
    public TransmissionStats getSourceTransmissionStats() {
        return this.sendStreamDesc.sendStream.getSourceTransmissionStats();
    }

    @Override
    public long getSSRC() {
        return this.sendStreamDesc.sendStream.getSSRC();
    }

    @Override
    public int setBitRate(int bitRate) {
        return 0;
    }

    @Override
    public void setSourceDescription(SourceDescription[] sourceDescription) {
    }

    @Override
    public void start() throws IOException {
        if (this.closed) {
            throw new IOException("Cannot start SendStream after it has been closed.");
        }
        if (!this.started) {
            this.sendStreamDesc.start(this);
            this.started = true;
        }
    }

    @Override
    public void stop() throws IOException {
        if (!this.closed && this.started) {
            this.sendStreamDesc.stop(this);
            this.started = false;
        }
    }
}

