/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.imgstreaming;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ImgStreamingUtils {
    public static BufferedImage getScaledImage(BufferedImage src, int width, int height, int type) {
        double scaleWidth = (double)width / (double)src.getWidth();
        double scaleHeight = (double)height / (double)src.getHeight();
        AffineTransform tx = new AffineTransform();
        if (Double.compare(scaleWidth, 1.0) != 0 || Double.compare(scaleHeight, 1.0) != 0) {
            tx.scale(scaleWidth, scaleHeight);
        }
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        BufferedImage dst = new BufferedImage(width, height, type);
        return op.filter(src, dst);
    }

    public static byte[] getImageBytes(BufferedImage src, byte[] output) {
        if (src.getType() != 2) {
            throw new IllegalArgumentException("src.type");
        }
        WritableRaster raster = src.getRaster();
        int width = src.getWidth();
        int height = src.getHeight();
        int size = width * height * 4;
        int off = 0;
        int[] pixel = new int[4];
        byte[] data = null;
        data = output == null || output.length < size ? new byte[size] : output;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                raster.getPixel(x, y, pixel);
                data[off++] = (byte)pixel[0];
                data[off++] = (byte)pixel[1];
                data[off++] = (byte)pixel[2];
                data[off++] = (byte)pixel[3];
            }
        }
        return data;
    }
}

