/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h263p;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.AbstractCodec;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;

public class JNIEncoder
extends AbstractCodec {
    private static final int DEFAULT_FRAME_RATE = 30;
    private static final Format[] DEFAULT_OUTPUT_FORMATS = new Format[]{new VideoFormat("h263-1998")};
    private static final int IFRAME_INTERVAL = 300;
    private static final String PLUGIN_NAME = "H.263+ Encoder";
    private long avcontext = 0L;
    private long avFrame = 0L;
    private int encFrameLen = 0;
    private int framesSinceLastIFrame = 301;
    private long rawFrameBuffer = 0L;

    public JNIEncoder() {
        this.inputFormats = new Format[]{new YUVFormat(null, -1, Format.byteArray, -1.0f, 2, -1, -1, -1, -1, -1)};
        this.inputFormat = null;
        this.outputFormat = null;
    }

    @Override
    public synchronized void close() {
        if (this.opened) {
            this.opened = false;
            super.close();
            FFmpeg.avcodec_close(this.avcontext);
            FFmpeg.av_free(this.avcontext);
            this.avcontext = 0L;
            FFmpeg.avcodec_free_frame(this.avFrame);
            this.avFrame = 0L;
            FFmpeg.av_free(this.rawFrameBuffer);
            this.rawFrameBuffer = 0L;
        }
    }

    private Format[] getMatchingOutputFormats(Format in) {
        VideoFormat videoIn = (VideoFormat)in;
        return new VideoFormat[]{new VideoFormat("h263-1998", videoIn.getSize(), -1, Format.byteArray, videoIn.getFrameRate())};
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public Format[] getSupportedOutputFormats(Format in) {
        if (in == null) {
            return DEFAULT_OUTPUT_FORMATS;
        }
        if (!(in instanceof VideoFormat) || null == AbstractCodec2.matches(in, this.inputFormats)) {
            return new Format[0];
        }
        return this.getMatchingOutputFormats(in);
    }

    @Override
    public synchronized void open() throws ResourceUnavailableException {
        if (this.opened) {
            return;
        }
        if (this.inputFormat == null) {
            throw new ResourceUnavailableException("No input format selected");
        }
        if (this.outputFormat == null) {
            throw new ResourceUnavailableException("No output format selected");
        }
        VideoFormat outputVideoFormat = (VideoFormat)this.outputFormat;
        Dimension size = outputVideoFormat.getSize();
        int width = size.width;
        int height = size.height;
        long avcodec = FFmpeg.avcodec_find_encoder(20);
        this.avcontext = FFmpeg.avcodec_alloc_context3(avcodec);
        FFmpeg.avcodeccontext_set_pix_fmt(this.avcontext, 0);
        FFmpeg.avcodeccontext_set_size(this.avcontext, width, height);
        FFmpeg.avcodeccontext_set_qcompress(this.avcontext, 0.6f);
        int bitRate = NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration().getVideoBitrate() * 1000;
        int frameRate = (int)outputVideoFormat.getFrameRate();
        if (frameRate == -1) {
            frameRate = 30;
        }
        FFmpeg.avcodeccontext_set_bit_rate(this.avcontext, bitRate);
        FFmpeg.avcodeccontext_set_bit_rate_tolerance(this.avcontext, bitRate / (frameRate - 1));
        FFmpeg.avcodeccontext_set_time_base(this.avcontext, 1, frameRate);
        FFmpeg.avcodeccontext_set_mb_decision(this.avcontext, 0);
        FFmpeg.avcodeccontext_add_flags(this.avcontext, 2048);
        FFmpeg.avcodeccontext_add_flags(this.avcontext, 0x2000000);
        FFmpeg.avcodeccontext_add_flags(this.avcontext, 0x1000000);
        FFmpeg.avcodeccontext_add_flags(this.avcontext, 0x10000000);
        FFmpeg.avcodeccontext_set_me_method(this.avcontext, 6);
        FFmpeg.avcodeccontext_set_me_subpel_quality(this.avcontext, 2);
        FFmpeg.avcodeccontext_set_me_range(this.avcontext, 18);
        FFmpeg.avcodeccontext_set_me_cmp(this.avcontext, 256);
        FFmpeg.avcodeccontext_set_scenechange_threshold(this.avcontext, 40);
        FFmpeg.avcodeccontext_set_gop_size(this.avcontext, 300);
        if (FFmpeg.avcodec_open2(this.avcontext, avcodec, new String[0]) < 0) {
            throw new ResourceUnavailableException("Could not open codec. (size= " + width + "x" + height + ")");
        }
        this.encFrameLen = width * height * 3 / 2;
        this.rawFrameBuffer = FFmpeg.av_malloc(this.encFrameLen);
        this.avFrame = FFmpeg.avcodec_alloc_frame();
        int sizeInBytes = width * height;
        FFmpeg.avframe_set_data(this.avFrame, this.rawFrameBuffer, sizeInBytes, sizeInBytes / 4);
        FFmpeg.avframe_set_linesize(this.avFrame, width, width / 2, width / 2);
        this.opened = true;
        super.open();
    }

    @Override
    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        byte[] out;
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            this.reset();
            return 0;
        }
        if (inBuffer.isDiscard()) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        if (inFormat != this.inputFormat && !inFormat.matches(this.inputFormat)) {
            this.setInputFormat(inFormat);
        }
        if (inBuffer.getLength() < 3) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        FFmpeg.memcpy(this.rawFrameBuffer, (byte[])inBuffer.getData(), inBuffer.getOffset(), this.encFrameLen);
        if (this.framesSinceLastIFrame >= 300) {
            FFmpeg.avframe_set_key_frame(this.avFrame, true);
            this.framesSinceLastIFrame = 0;
        } else {
            ++this.framesSinceLastIFrame;
            FFmpeg.avframe_set_key_frame(this.avFrame, false);
        }
        Object outData = outBuffer.getData();
        if (outData instanceof byte[]) {
            out = (byte[])outData;
            if (out.length < this.encFrameLen) {
                out = null;
            }
        } else {
            out = null;
        }
        if (out == null) {
            out = new byte[this.encFrameLen];
        }
        int outputLength = FFmpeg.avcodec_encode_video(this.avcontext, out, out.length, this.avFrame);
        outBuffer.setData(out);
        outBuffer.setLength(outputLength);
        outBuffer.setOffset(0);
        outBuffer.setTimeStamp(inBuffer.getTimeStamp());
        return 0;
    }

    @Override
    public Format setInputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == AbstractCodec2.matches(format, this.inputFormats)) {
            return null;
        }
        YUVFormat yuvFormat = (YUVFormat)format;
        if (yuvFormat.getOffsetU() > yuvFormat.getOffsetV()) {
            return null;
        }
        this.inputFormat = AbstractCodec2.specialize(yuvFormat, Format.byteArray);
        return this.inputFormat;
    }

    @Override
    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == AbstractCodec2.matches(format, this.getMatchingOutputFormats(this.inputFormat))) {
            return null;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension size = null;
        if (this.inputFormat != null) {
            size = ((VideoFormat)this.inputFormat).getSize();
        }
        if (size == null && format.matches(this.outputFormat)) {
            size = ((VideoFormat)this.outputFormat).getSize();
        }
        this.outputFormat = new VideoFormat(videoFormat.getEncoding(), size, -1, Format.byteArray, videoFormat.getFrameRate());
        return this.outputFormat;
    }
}

