/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.fmj.media.rtp.DefaultRTCPReportBuilderImpl;
import net.sf.fmj.media.rtp.OverallStats;
import net.sf.fmj.media.rtp.RTCPBYEPacket;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRawSender;
import net.sf.fmj.media.rtp.RTCPReportBuilder;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import net.sf.fmj.media.rtp.SendSSRCInfo;
import net.sf.fmj.media.rtp.util.UDPPacketSender;

public class RTCPTransmitter {
    private static final Logger logger = Logger.getLogger(RTCPTransmitter.class.getName());
    RTCPRawSender sender;
    OverallStats stats = null;
    public SSRCCache cache;
    RTCPReportBuilder reportBuilder;
    public SSRCInfo ssrcInfo = null;

    public RTCPTransmitter(SSRCCache cache) {
        this.cache = cache;
        this.stats = cache.sm.defaultstats;
    }

    public RTCPTransmitter(SSRCCache cache, int port, String address) throws UnknownHostException, IOException {
        this(cache, new RTCPRawSender(port, address));
    }

    public RTCPTransmitter(SSRCCache cache, int port, String address, UDPPacketSender sender) throws UnknownHostException, IOException {
        this(cache, new RTCPRawSender(port, address, sender));
    }

    public RTCPTransmitter(SSRCCache cache, RTCPRawSender sender) {
        this(cache);
        this.setSender(sender);
        this.stats = cache.sm.defaultstats;
    }

    public void bye(int ssrc, byte[] reason) {
        double delay;
        RTCPPacket[] packets;
        RTCPPacket[] reports;
        if (!this.cache.rtcpsent) {
            return;
        }
        this.cache.byestate = true;
        RTCPReportBuilder rb = this.getReportBuilder();
        try {
            reports = rb.makeReports();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "makeReports() crashed", e);
            reports = new RTCPPacket[]{};
        }
        if (reports == null || reports.length == 0) {
            packets = new RTCPPacket[1];
        } else {
            packets = new RTCPPacket[reports.length + 1];
            System.arraycopy(reports, 0, packets, 0, reports.length);
        }
        int[] ssrclist = new int[]{ssrc};
        RTCPBYEPacket byep = new RTCPBYEPacket(ssrclist, reason);
        packets[packets.length - 1] = byep;
        RTCPCompoundPacket cp = new RTCPCompoundPacket(packets);
        if (this.cache.aliveCount() > 50) {
            this.cache.reset(byep.length);
            delay = this.cache.calcReportInterval(this.ssrcInfo.sender, false);
        } else {
            delay = 0.0;
        }
        try {
            Thread.sleep((long)delay);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.transmit(cp);
        rb.reset();
    }

    public void bye(String reason) {
        if (reason != null) {
            this.bye(this.ssrcInfo.ssrc, reason.getBytes());
        } else {
            this.bye(this.ssrcInfo.ssrc, null);
        }
    }

    public void close() {
        if (this.sender != null) {
            this.sender.closeConsumer();
        }
    }

    public RTCPRawSender getSender() {
        return this.sender;
    }

    public void report() {
        RTCPPacket[] packets;
        try {
            packets = this.getReportBuilder().makeReports();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "makeReports() crashed", e);
            packets = null;
        }
        if (packets != null && packets.length != 0) {
            RTCPCompoundPacket compoundPacket = new RTCPCompoundPacket(packets);
            this.transmit(compoundPacket);
        }
    }

    public void setSender(RTCPRawSender s) {
        this.sender = s;
    }

    public void setSSRCInfo(SSRCInfo info) {
        this.ssrcInfo = info;
    }

    protected void transmit(RTCPCompoundPacket p) {
        try {
            this.sender.sendTo(p);
        }
        catch (IOException e) {
            this.stats.update(6, 1);
            ++this.cache.sm.transstats.transmit_failed;
            return;
        }
        this.onRTCPCompoundPacketSent(p);
    }

    public void onRTCPCompoundPacketSent(RTCPCompoundPacket p) {
        if (this.ssrcInfo instanceof SendSSRCInfo) {
            ++((SendSSRCInfo)this.ssrcInfo).stats.total_rtcp;
            ++this.cache.sm.transstats.rtcp_sent;
        }
        this.cache.updateavgrtcpsize(p.length);
        if (this.cache.initial) {
            this.cache.initial = false;
        }
        if (!this.cache.rtcpsent) {
            this.cache.rtcpsent = true;
        }
    }

    public void setReportBuilder(RTCPReportBuilder reportBuilder) {
        this.reportBuilder = reportBuilder;
        if (this.reportBuilder != null) {
            try {
                this.reportBuilder.setRTCPTransmitter(this);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "The report builder did not accept the RTCPTransmitter", e);
            }
        }
    }

    private RTCPReportBuilder getReportBuilder() {
        if (this.reportBuilder == null) {
            this.setReportBuilder(new DefaultRTCPReportBuilderImpl());
        }
        return this.reportBuilder;
    }
}

