/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.control;

import java.awt.Component;
import java.util.Vector;
import javax.media.Control;
import net.sf.fmj.media.control.AtomicControl;
import net.sf.fmj.media.control.ControlChangeEvent;
import net.sf.fmj.media.control.ControlChangeListener;

public class AtomicControlAdapter
implements AtomicControl {
    protected Component component = null;
    private Vector listeners = null;
    protected boolean isdefault = false;
    protected Control parent = null;
    protected boolean enabled = true;

    public AtomicControlAdapter(Component c, boolean def, Control parent) {
        this.component = c;
        this.isdefault = def;
        this.parent = parent;
    }

    public void addControlChangeListener(ControlChangeListener ccl) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (ccl != null) {
            this.listeners.addElement(ccl);
        }
    }

    public Component getControlComponent() {
        return this.component;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Control getParent() {
        return this.parent;
    }

    public String getTip() {
        return null;
    }

    public boolean getVisible() {
        return true;
    }

    public void informListeners() {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ControlChangeListener ccl = (ControlChangeListener)this.listeners.elementAt(i);
                ccl.controlChanged(new ControlChangeEvent(this));
            }
        }
    }

    public boolean isDefault() {
        return this.isdefault;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void removeControlChangeListener(ControlChangeListener ccl) {
        if (this.listeners != null && ccl != null) {
            this.listeners.removeElement(ccl);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.component != null) {
            this.component.setEnabled(enabled);
        }
        this.informListeners();
    }

    public void setParent(Control p) {
        this.parent = p;
    }

    public void setTip(String tip) {
    }

    public void setVisible(boolean visible) {
    }
}

