/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.util.Collection;
import java.util.HashSet;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidateExtendedType;
import org.ice4j.ice.Component;
import org.ice4j.ice.HostCandidate;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.ServerReflexiveCandidate;
import org.ice4j.ice.harvest.CandidateHarvester;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingCandidateHarvester
extends CandidateHarvester {
    private TransportAddress mask;
    private TransportAddress face;

    public MappingCandidateHarvester(TransportAddress mask, TransportAddress face) {
        this.mask = mask;
        this.face = face;
    }

    @Override
    public Collection<LocalCandidate> harvest(Component component) {
        if (this.mask == null || this.face == null) {
            return null;
        }
        HashSet<LocalCandidate> candidates = new HashSet<LocalCandidate>();
        for (Candidate candidate : component.getLocalCandidates()) {
            if (!(candidate instanceof HostCandidate) || !candidate.getTransportAddress().getHostAddress().equals(this.face.getHostAddress()) || candidate.getTransport() != this.face.getTransport()) continue;
            HostCandidate hostCandidate = (HostCandidate)candidate;
            TransportAddress mappedAddress = new TransportAddress(this.mask.getHostAddress(), hostCandidate.getHostAddress().getPort(), hostCandidate.getHostAddress().getTransport());
            ServerReflexiveCandidate mappedCandidate = new ServerReflexiveCandidate(mappedAddress, hostCandidate, hostCandidate.getStunServerAddress(), CandidateExtendedType.STATICALLY_MAPPED_CANDIDATE);
            if (hostCandidate.isSSL()) {
                mappedCandidate.setSSL(true);
            }
            if (candidates.contains(mappedCandidate) || !component.addLocalCandidate(mappedCandidate)) continue;
            candidates.add(mappedCandidate);
        }
        return candidates;
    }
}

