/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.handlers;

import java.io.IOException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.mn.communicator.GGException;
import pl.mn.communicator.packet.GGUtils;
import pl.mn.communicator.packet.handlers.PacketContext;
import pl.mn.communicator.packet.handlers.PacketHandler;
import pl.mn.communicator.packet.in.GGUserListReply;

public class GGUserListReplyHandler
implements PacketHandler {
    private static final Log LOGGER = LogFactory.getLog((Class)GGUserListReplyHandler.class);

    public void handle(PacketContext context) throws GGException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"GGUserlistReply packet received.");
            LOGGER.debug((Object)("PacketHeader: " + context.getHeader()));
            LOGGER.debug((Object)("Got packet: " + GGUtils.prettyBytesToString(context.getPackageContent())));
        }
        try {
            GGUserListReply userListReply = new GGUserListReply(context.getPackageContent());
            context.getSessionAccessor().notifyGGPacketReceived(userListReply);
            if (userListReply.isPutReply()) {
                LOGGER.debug((Object)"GGUserListReply.PutReply");
                context.getSessionAccessor().notifyContactListExported();
            } else if (userListReply.isGetMoreReply()) {
                LOGGER.debug((Object)"GGUserListReply.GetMoreReply");
                Collection contactList = userListReply.getContactList();
                context.getSessionAccessor().notifyContactListReceived(contactList);
            } else if (userListReply.isGetReply()) {
                LOGGER.debug((Object)"GGUserListReply.GetReply");
                Collection contactList = userListReply.getContactList();
                context.getSessionAccessor().notifyContactListReceived(contactList);
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Unable to handle incomming packet: " + GGUtils.prettyBytesToString(context.getPackageContent())), (Throwable)ex);
            throw new GGException("Unable to handle incoming user list packet.", ex);
        }
    }
}

