/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.AbstractInfoCmd;

public class MetaMoreInfoCmd
extends AbstractInfoCmd {
    private int age;
    private int gender;
    private String homepage;
    private Date birthDate;
    private int[] speakingLanguages = new int[3];
    private String originalCity;
    private String originalState;
    private int originalCountryCode;
    private int timeZone;

    protected MetaMoreInfoCmd(SnacPacket packet) {
        super(packet);
    }

    protected MetaMoreInfoCmd(long uin, int id) {
        super(uin, AbstractIcqCmd.CMD_META_MORE_INFO_CMD, id);
    }

    protected void readInfo(InputStream is) throws IOException {
        this.age = LEBinaryTools.readUShort(is);
        this.gender = is.read();
        this.homepage = LEBinaryTools.readUShortLengthString(is);
        int year = LEBinaryTools.readUShort(is);
        int month = is.read();
        int day = is.read();
        this.birthDate = new GregorianCalendar(year, month, day).getTime();
        this.speakingLanguages = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.speakingLanguages[i] = is.read();
        }
        is.skip(2L);
        this.originalCity = LEBinaryTools.readUShortLengthString(is);
        this.originalState = LEBinaryTools.readUShortLengthString(is);
        this.originalCountryCode = LEBinaryTools.readUShort(is);
        this.timeZone = is.read();
    }

    protected void writeInfo(OutputStream out) throws IOException {
        LEBinaryTools.writeUShort(out, this.age);
        LEBinaryTools.writeUByte(out, this.gender);
        LEBinaryTools.writeUShortLengthString(out, this.homepage);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(this.birthDate);
        LEBinaryTools.writeUShort(out, gc.get(1));
        LEBinaryTools.writeUByte(out, gc.get(2));
        LEBinaryTools.writeUByte(out, gc.get(5));
        for (int i = 0; i < 3; ++i) {
            LEBinaryTools.writeUByte(out, this.speakingLanguages[i]);
        }
        LEBinaryTools.writeUShort(out, 0);
        LEBinaryTools.writeUShortLengthString(out, this.originalCity);
        LEBinaryTools.writeUShortLengthString(out, this.originalState);
        LEBinaryTools.writeUShort(out, this.originalCountryCode);
        LEBinaryTools.writeUByte(out, this.timeZone);
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public int getGender() {
        return this.gender;
    }

    public void setGender(int gender) {
        this.gender = gender;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public Date getBirthDate() {
        return this.birthDate;
    }

    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    public int[] getSpeakingLanguages() {
        return this.speakingLanguages;
    }

    public void setSpeakingLanguages(int[] speakingLanguages) {
        this.speakingLanguages = speakingLanguages;
    }

    public String getOriginalCity() {
        return this.originalCity;
    }

    public void setOriginalCity(String originalCity) {
        this.originalCity = originalCity;
    }

    public String getOriginalState() {
        return this.originalState;
    }

    public void setOriginalState(String originalState) {
        this.originalState = originalState;
    }

    public int getOriginalCountryCode() {
        return this.originalCountryCode;
    }

    public void setOriginalCountryCode(int originalCountryCode) {
        this.originalCountryCode = originalCountryCode;
    }

    public int getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(int timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        return "MetaMoreInfoCmd: age=" + this.getAge() + " gender=" + this.getGender() + " homepage=" + this.getHomepage() + " birthDate=" + this.getBirthDate() + " speakingLanguages=[" + this.speakingLanguages[0] + "," + this.speakingLanguages[1] + "," + this.speakingLanguages[2] + "] originalCity=" + this.getOriginalCity() + " originalState=" + this.getOriginalState() + " originalCountry=" + this.getOriginalCountryCode() + " timeZone=" + this.getTimeZone() + " in: " + super.toString();
    }
}

