/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import org.jetbrains.annotations.Nullable;

public final class WarningLevel
extends Number {
    private static final WarningLevel LEVEL_ZERO = new WarningLevel(0);
    private static final WarningLevel LEVEL_999 = new WarningLevel(999);
    private final float fv;
    private final int rv;
    private final int orig;

    @Nullable
    public static WarningLevel getInstanceFromX10(int x10) {
        if (x10 < 0) {
            return null;
        }
        if (x10 == 0) {
            return LEVEL_ZERO;
        }
        if (x10 == 999) {
            return LEVEL_999;
        }
        return new WarningLevel(x10);
    }

    public static WarningLevel getInstanceFromPercent(int pc) {
        return WarningLevel.getInstanceFromX10(pc * 10);
    }

    private WarningLevel(int x10) {
        this.orig = x10;
        this.fv = (float)x10 / 10.0f;
        this.rv = Math.round(this.fv);
    }

    public double doubleValue() {
        return this.fv;
    }

    public float floatValue() {
        return this.fv;
    }

    public int intValue() {
        return this.rv;
    }

    public long longValue() {
        return this.rv;
    }

    public int getX10Value() {
        return this.orig;
    }

    public String toString() {
        return this.intValue() + "." + this.getX10Value() % 10 + "%";
    }
}

