/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.partition.InternalPartitionService;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.RingbufferProxy;
import com.hazelcast.ringbuffer.impl.operations.ReplicationOperation;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RingbufferService
implements ManagedService,
RemoteService,
MigrationAwareService {
    public static final String TOPIC_RB_PREFIX = "_hz_rb_";
    public static final String SERVICE_NAME = "hz:impl:ringbufferService";
    private NodeEngine nodeEngine;
    private final ConcurrentMap<String, RingbufferContainer> containers = new ConcurrentHashMap<String, RingbufferContainer>();

    public RingbufferService(NodeEngineImpl nodeEngine) {
        this.nodeEngine = Preconditions.checkNotNull(nodeEngine, "nodeEngine can't be null");
    }

    public ConcurrentMap<String, RingbufferContainer> getContainers() {
        return this.containers;
    }

    @Override
    public DistributedObject createDistributedObject(String objectName) {
        RingbufferConfig ringbufferConfig = this.getRingbufferConfig(objectName);
        return new RingbufferProxy(this.nodeEngine, this, objectName, ringbufferConfig);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.containers.remove(name);
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, name);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        HashMap<String, RingbufferContainer> migrationData = new HashMap<String, RingbufferContainer>();
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        for (Map.Entry entry : this.containers.entrySet()) {
            String name = (String)entry.getKey();
            int partitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            RingbufferContainer container = (RingbufferContainer)entry.getValue();
            int backupCount = container.getConfig().getTotalBackupCount();
            if (partitionId != event.getPartitionId() || backupCount < event.getReplicaIndex()) continue;
            migrationData.put(name, container);
        }
        if (migrationData.isEmpty()) {
            return null;
        }
        return new ReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearMigrationData(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearMigrationData(event.getPartitionId());
        }
    }

    private void clearMigrationData(int partitionId) {
        Iterator iterator = this.containers.entrySet().iterator();
        InternalPartitionService partitionService = this.nodeEngine.getPartitionService();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = (String)entry.getKey();
            int containerPartitionId = partitionService.getPartitionId(StringPartitioningStrategy.getPartitionKey(name));
            if (containerPartitionId != partitionId) continue;
            iterator.remove();
        }
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.clearMigrationData(partitionId);
    }

    public RingbufferContainer getContainer(String name) {
        RingbufferContainer ringbuffer = (RingbufferContainer)this.containers.get(name);
        if (ringbuffer != null) {
            return ringbuffer;
        }
        RingbufferConfig ringbufferConfig = this.getRingbufferConfig(name);
        ringbuffer = new RingbufferContainer(name, ringbufferConfig, this.nodeEngine.getSerializationService());
        this.containers.put(name, ringbuffer);
        return ringbuffer;
    }

    private RingbufferConfig getRingbufferConfig(String name) {
        Config config = this.nodeEngine.getConfig();
        return config.getRingbufferConfig(RingbufferService.getConfigName(name));
    }

    public void addRingbuffer(String name, RingbufferContainer ringbuffer) {
        Preconditions.checkNotNull(name, "name can't be null");
        Preconditions.checkNotNull(ringbuffer, "ringbuffer can't be null");
        ringbuffer.init(this.nodeEngine);
        this.containers.put(name, ringbuffer);
    }

    private static String getConfigName(String name) {
        if (name.startsWith(TOPIC_RB_PREFIX)) {
            name = name.substring(TOPIC_RB_PREFIX.length());
        }
        return name;
    }
}

