/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.partition.impl;

import com.hazelcast.cluster.impl.operations.JoinOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.MigrationCycleOperation;
import com.hazelcast.partition.PartitionRuntimeState;
import com.hazelcast.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.spi.AbstractOperation;
import java.io.IOException;

public final class PartitionStateOperation
extends AbstractOperation
implements MigrationCycleOperation,
JoinOperation {
    private PartitionRuntimeState partitionState;
    private boolean sync;

    public PartitionStateOperation() {
    }

    public PartitionStateOperation(PartitionRuntimeState partitionState) {
        this(partitionState, false);
    }

    public PartitionStateOperation(PartitionRuntimeState partitionState, boolean sync) {
        this.partitionState = partitionState;
        this.sync = sync;
    }

    @Override
    public void run() {
        this.partitionState.setEndpoint(this.getCallerAddress());
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        partitionService.processPartitionRuntimeState(this.partitionState);
    }

    @Override
    public boolean returnsResponse() {
        return this.sync;
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.partitionState = new PartitionRuntimeState();
        this.partitionState.readData(in);
        this.sync = in.readBoolean();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.partitionState.writeData(out);
        out.writeBoolean(this.sync);
    }
}

