/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.multimap.impl;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.multimap.impl.MultiMapContainer;
import com.hazelcast.multimap.impl.MultiMapService;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MultiMapPartitionContainer {
    final int partitionId;
    final MultiMapService service;
    final ConcurrentMap<String, MultiMapContainer> containerMap = new ConcurrentHashMap<String, MultiMapContainer>(1000);
    private final ConstructorFunction<String, MultiMapContainer> containerConstructor = new ConstructorFunction<String, MultiMapContainer>(){

        @Override
        public MultiMapContainer createNew(String name) {
            return new MultiMapContainer(name, MultiMapPartitionContainer.this.service, MultiMapPartitionContainer.this.partitionId);
        }
    };

    public MultiMapPartitionContainer(MultiMapService service, int partitionId) {
        this.service = service;
        this.partitionId = partitionId;
    }

    public MultiMapContainer getOrCreateMultiMapContainer(String name) {
        MultiMapContainer container = ConcurrencyUtil.getOrPutIfAbsent(this.containerMap, name, this.containerConstructor);
        container.access();
        return container;
    }

    public MultiMapContainer getCollectionContainer(String name) {
        MultiMapContainer container = (MultiMapContainer)this.containerMap.get(name);
        if (container != null) {
            container.access();
        }
        return container;
    }

    public boolean containsCollection(String name) {
        return this.containerMap.containsKey(name);
    }

    void destroyCollection(String name) {
        MultiMapContainer container = (MultiMapContainer)this.containerMap.remove(name);
        if (container != null) {
            container.destroy();
        } else {
            this.clearLockStore(name);
        }
    }

    private void clearLockStore(String name) {
        NodeEngine nodeEngine = this.service.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            DefaultObjectNamespace namespace = new DefaultObjectNamespace("hz:impl:multiMapService", name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
    }

    void destroy() {
        for (MultiMapContainer container : this.containerMap.values()) {
            container.destroy();
        }
        this.containerMap.clear();
    }
}

