/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.list.client;

import com.hazelcast.collection.impl.collection.client.CollectionRequest;
import com.hazelcast.collection.impl.list.operations.ListSetOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;

public class ListSetRequest
extends CollectionRequest {
    private int index;
    private Data value;

    public ListSetRequest() {
    }

    public ListSetRequest(String name, int index, Data value) {
        super(name);
        this.index = index;
        this.value = value;
    }

    @Override
    protected Operation prepareOperation() {
        return new ListSetOperation(this.name, this.index, this.value);
    }

    @Override
    public int getClassId() {
        return 12;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("i", this.index);
        writer.getRawDataOutput().writeData(this.value);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.index = reader.readInt("i");
        this.value = reader.getRawDataInput().readData();
    }

    @Override
    public String getRequiredAction() {
        return "read";
    }

    @Override
    public String getMethodName() {
        return "set";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.index, this.value};
    }
}

