/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.io.File;
import java.io.IOException;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;

class RrdNode {
    private int dsIndex = -1;
    private int arcIndex = -1;
    private String label;

    RrdNode(RrdDb rrdDb) {
        String string = rrdDb.getRrdBackend().getPath();
        this.label = new File(string).getName();
    }

    RrdNode(RrdDb rrdDb, int n) throws IOException, RrdException {
        this.dsIndex = n;
        RrdDef rrdDef = rrdDb.getRrdDef();
        DsDef[] dsDefArray = rrdDef.getDsDefs();
        this.label = dsDefArray[n].dump();
    }

    RrdNode(RrdDb rrdDb, int n, int n2) throws IOException, RrdException {
        this.dsIndex = n;
        this.arcIndex = n2;
        ArcDef[] arcDefArray = rrdDb.getRrdDef().getArcDefs();
        this.label = arcDefArray[n2].dump();
    }

    int getDsIndex() {
        return this.dsIndex;
    }

    int getArcIndex() {
        return this.arcIndex;
    }

    public String toString() {
        return this.label;
    }
}

