/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.Writer;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.ChangePrefixMapping;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.Comment;
import weblogic.xml.stream.EndDocument;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.EndPrefixMapping;
import weblogic.xml.stream.EntityReference;
import weblogic.xml.stream.ProcessingInstruction;
import weblogic.xml.stream.Space;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.StartPrefixMapping;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public class XMLEventWriter
extends XMLWriter {
    public XMLEventWriter() {
    }

    public XMLEventWriter(Writer writer) {
        super(writer);
    }

    protected void writeType(XMLEvent xMLEvent) throws XMLStreamException {
        this.write('[');
        this.write(xMLEvent.getTypeAsString());
        this.write(']');
    }

    public void write(StartElement startElement) throws XMLStreamException {
        this.write('[');
        this.write(startElement.getName());
        this.write("][");
        if (this.writeElementNameSpaces) {
            this.write(startElement.getAttributesAndNamespaces());
        } else {
            this.write(startElement.getAttributes());
        }
        this.write(']');
    }

    public void write(EndElement endElement) throws XMLStreamException {
        this.write('[');
        this.write(endElement.getName());
        this.write(']');
    }

    public void write(ProcessingInstruction processingInstruction) throws XMLStreamException {
        this.write('[');
        if (processingInstruction.getTarget() != null) {
            this.write(processingInstruction.getTarget());
        }
        if (processingInstruction.getData() != null) {
            this.write("],[" + processingInstruction.getData());
        }
        this.write(']');
    }

    public void write(CharacterData characterData) throws XMLStreamException {
        this.write('[');
        if (characterData.hasContent()) {
            this.write(characterData.getContent());
        }
        this.write(']');
    }

    public void write(StartDocument startDocument) throws XMLStreamException {
        if (!this.writeHeader) {
            return;
        }
        this.write("[" + startDocument.getVersion() + "]");
        if (startDocument.getCharacterEncodingScheme() != null) {
            this.write(",[" + startDocument.getCharacterEncodingScheme() + "]");
        } else {
            this.write(",[]");
        }
        if (startDocument.isStandalone()) {
            this.write(",[yes]");
        } else {
            this.write(",[no]");
        }
    }

    public void write(EndDocument endDocument) throws XMLStreamException {
    }

    public void write(Comment comment) throws XMLStreamException {
        this.write('[');
        if (comment.hasContent()) {
            comment.getContent();
        }
        this.write(']');
    }

    protected void writeNamespace(String string, String string2) throws XMLStreamException {
        this.write("[" + string + "," + string2 + "]");
    }

    public void write(StartPrefixMapping startPrefixMapping) throws XMLStreamException {
        this.prefixMap.put(startPrefixMapping.getPrefix(), startPrefixMapping.getNamespaceUri());
        if (!this.writeAll) {
            return;
        }
        this.writeNamespace(startPrefixMapping.getPrefix(), startPrefixMapping.getNamespaceUri());
    }

    public void write(ChangePrefixMapping changePrefixMapping) throws XMLStreamException {
        this.prefixMap.put(changePrefixMapping.getPrefix(), changePrefixMapping.getNewNamespaceUri());
        if (!this.writeAll) {
            return;
        }
        this.write("[");
        this.writeNamespace(changePrefixMapping.getPrefix(), changePrefixMapping.getOldNamespaceUri());
        this.write(",");
        this.writeNamespace(changePrefixMapping.getPrefix(), changePrefixMapping.getNewNamespaceUri());
        this.write("]");
    }

    public void write(EndPrefixMapping endPrefixMapping) throws XMLStreamException {
        this.prefixMap.remove(endPrefixMapping.getPrefix());
        if (!this.writeAll) {
            return;
        }
        this.write("[" + endPrefixMapping.getPrefix() + "]");
    }

    public void write(XMLName xMLName) throws XMLStreamException {
        if (this.showNamespaceBindings && xMLName.getNamespaceUri() != null) {
            this.write("['" + xMLName.getNamespaceUri() + "']:" + xMLName.getQualifiedName());
        } else {
            this.write(xMLName.getQualifiedName());
        }
    }

    public void write(AttributeIterator attributeIterator) throws XMLStreamException {
        while (attributeIterator.hasNext()) {
            this.write(" ");
            this.write(attributeIterator.next());
        }
    }

    public void write(Attribute attribute) throws XMLStreamException {
        this.write('[');
        this.write(attribute.getName());
        this.write(",");
        this.write(attribute.getValue());
        this.write(']');
    }

    public void write(EntityReference entityReference) throws XMLStreamException {
        this.write('[');
        this.write(entityReference.getName());
        this.write(']');
    }

    public void write(Space space) throws XMLStreamException {
        this.write('[');
        if (space.hasContent()) {
            this.write(space.getContent());
        }
        this.write(']');
    }

    public boolean write(XMLEvent xMLEvent) throws XMLStreamException {
        this.writeType(xMLEvent);
        switch (xMLEvent.getType()) {
            case 2: {
                this.write((StartElement)xMLEvent);
                break;
            }
            case 4: {
                this.write((EndElement)xMLEvent);
                break;
            }
            case 8: {
                this.write((ProcessingInstruction)xMLEvent);
                break;
            }
            case 16: {
                this.write((CharacterData)xMLEvent);
                break;
            }
            case 32: {
                this.write((Comment)xMLEvent);
                break;
            }
            case 256: {
                this.write((StartDocument)xMLEvent);
                break;
            }
            case 512: {
                this.write((EndDocument)xMLEvent);
                break;
            }
            case 1024: {
                this.write((StartPrefixMapping)xMLEvent);
                break;
            }
            case 2048: {
                this.write((EndPrefixMapping)xMLEvent);
                break;
            }
            case 4096: {
                this.write((ChangePrefixMapping)xMLEvent);
                break;
            }
            case 8192: {
                this.write((EntityReference)xMLEvent);
                break;
            }
            case 64: {
                this.write((Space)xMLEvent);
                break;
            }
            case 128: {
                throw new XMLStreamException("Attempt to write a null element.");
            }
            default: {
                throw new XMLStreamException("Attempt to write unknown element [" + xMLEvent.getType() + "]");
            }
        }
        this.write(";\n");
        return true;
    }

    public static XMLWriter getWriter(Writer writer) throws XMLStreamException {
        XMLEventWriter xMLEventWriter = new XMLEventWriter();
        xMLEventWriter.setWriter(writer);
        xMLEventWriter.setWriteHeader(true);
        xMLEventWriter.setWriteElementNameSpaces(true);
        xMLEventWriter.setWriteAll(true);
        xMLEventWriter.setShowNamespaceBindings(true);
        xMLEventWriter.setNormalizeWhiteSpace(false);
        return xMLEventWriter;
    }
}

