/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;
import weblogic.xml.babel.baseparser.Attribute;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.reader.XmlReader;
import weblogic.xml.babel.scanner.ScannerException;

public class SAXElementFactory {
    public static String nullToEmptyString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static Attributes createAttributes(ArrayList arrayList) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.clear();
        ListIterator listIterator = arrayList.listIterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (listIterator.hasNext()) {
            Attribute attribute = (Attribute)listIterator.next();
            attributesImpl.addAttribute(SAXElementFactory.nullToEmptyString(attribute.uri), attribute.name, attribute.getRawName(), "CDATA", attribute.getValue());
            if (hashSet.contains(attribute.getNSName())) {
                throw new SAXException("Attributes may not have the same name, more than one" + attribute.getName());
            }
            hashSet.add(attribute.getNSName());
        }
        return attributesImpl;
    }

    public static Locator createLocator(BaseParser baseParser) {
        LocatorImpl locatorImpl = new LocatorImpl();
        locatorImpl.setLineNumber(baseParser.getLine());
        locatorImpl.setColumnNumber(baseParser.getColumn());
        return locatorImpl;
    }

    public static Locator createLocator(Element element) {
        LocatorImpl locatorImpl = new LocatorImpl();
        locatorImpl.setLineNumber(element.getLine());
        locatorImpl.setColumnNumber(element.getColumn());
        return locatorImpl;
    }

    public static SAXParseException createSAXParseException(ScannerException scannerException, Locator locator) {
        return new SAXParseException(scannerException.getMessage(), locator, scannerException);
    }

    public static SAXParseException createSAXParseException(ParseException parseException, Locator locator) {
        return new SAXParseException(parseException.getMessage(), locator, parseException);
    }

    public static SAXParseException createSAXParseException(Exception exception, Locator locator) {
        return new SAXParseException(exception.getMessage(), locator, exception);
    }

    public static InputSource createInputSource(File file) throws IOException {
        InputSource inputSource = new InputSource(XmlReader.createReader(new BufferedInputStream(new FileInputStream(file))));
        String string = file.toURL().toString();
        inputSource.setSystemId("file:" + string);
        return inputSource;
    }

    public static InputSource createInputSource(String string) throws IOException {
        InputSource inputSource = new InputSource(XmlReader.createReader(new BufferedInputStream(new FileInputStream(string))));
        return inputSource;
    }
}

