/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.io.IOException;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.scanner.ScannerException;

public abstract class Element {
    protected String prefix;
    protected String name;
    protected String uri;
    protected int line = 0;
    protected int column = 0;
    public int type;
    public static final int STAG = 0;
    public static final int EMPTYELEMTAG = 1;
    public static final int ELEMENT = 2;
    public static final int ETAG = 3;
    public static final int PI = 4;
    public static final int CHARDATA = 5;
    public static final int COMMENT = 6;
    public static final int SPACE = 7;
    public static final int NULLELEMENT = 8;
    public static final int EOF = 9;
    static final String[] nameArray = new String[]{"STAG", "EMPTYELEMTAG", "ELEMENT", "ETAG", "PI", "CHARDATA", "COMMENT", "SPACE", "NULLELEMENT", "EOF"};

    public abstract void parse(BaseParser var1) throws IOException, ScannerException, ParseException;

    public static final String getString(int n) {
        return nameArray[n];
    }

    public String getName() {
        if (this.uri != null && this.prefix != null) {
            return "['" + this.uri + "']:" + this.prefix + ":" + this.name;
        }
        if (this.uri != null) {
            return "['" + this.uri + "']:" + this.name;
        }
        if (this.prefix != null) {
            return this.prefix + ":" + this.name;
        }
        return this.name;
    }

    public String getRawName() {
        if (this.prefix != null) {
            return this.prefix + ":" + this.name;
        }
        return this.name;
    }

    public String getNSName() {
        if (this.uri != null) {
            return this.uri + ":" + this.name;
        }
        return this.name;
    }

    protected void init() {
        this.uri = null;
        this.prefix = null;
        this.name = null;
        this.type = 2;
    }

    protected boolean setNameSpace(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        if (this.prefix != null) {
            this.uri = baseParser.getNameSpace(this.prefix);
            return true;
        }
        return false;
    }

    protected boolean setDefaultNameSpace(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        if (baseParser.isDefaultNameSpaceSet()) {
            this.uri = baseParser.getDefaultNameSpace();
            return true;
        }
        return false;
    }

    public void setLocalName(String string) {
        this.name = string;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setURI(String string) {
        this.uri = string;
    }

    public String getLocalName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public void setPosition(BaseParser baseParser) {
        this.line = baseParser.getLine();
        this.column = baseParser.getColumn();
    }
}

