/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.adapters;

import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import weblogic.xml.babel.adapters.ElementConsumer;
import weblogic.xml.babel.baseparser.PrefixMapping;
import weblogic.xml.babel.baseparser.SymbolTable;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.AttributeImpl;
import weblogic.xml.stream.events.ChangePrefixMappingEvent;
import weblogic.xml.stream.events.CharacterDataEvent;
import weblogic.xml.stream.events.CommentEvent;
import weblogic.xml.stream.events.EndDocumentEvent;
import weblogic.xml.stream.events.EndElementEvent;
import weblogic.xml.stream.events.EndPrefixMappingEvent;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.events.ProcessingInstructionEvent;
import weblogic.xml.stream.events.SpaceEvent;
import weblogic.xml.stream.events.StartDocumentEvent;
import weblogic.xml.stream.events.StartElementEvent;
import weblogic.xml.stream.events.StartPrefixMappingEvent;

public class DOMAdapter {
    private boolean debug = false;
    protected ElementConsumer consumer;
    protected SymbolTable nameSpaceTable = new SymbolTable();

    public DOMAdapter() {
        this.nameSpaceTable.put("", null);
        this.nameSpaceTable.put("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public DOMAdapter(ElementConsumer elementConsumer) {
        this();
        this.consumer = elementConsumer;
    }

    public void setElementConsumer(ElementConsumer elementConsumer) {
        this.consumer = elementConsumer;
    }

    public ElementConsumer getElementConsumer() {
        return this.consumer;
    }

    public void adapt(Node node) throws XMLStreamException {
        switch (node.getNodeType()) {
            case 9: {
                Document document = (Document)node;
                this.adaptDocument(document);
                break;
            }
            case 11: {
                DocumentFragment documentFragment = (DocumentFragment)node;
                this.adaptDocumentFragment(documentFragment);
                break;
            }
            case 1: {
                this.adaptElement(node);
                break;
            }
            case 3: 
            case 4: {
                this.adaptText(node);
                break;
            }
            case 7: {
                this.adaptProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 5: {
                this.adaptReference((EntityReference)node);
                break;
            }
            case 8: {
                this.adaptComment((Comment)node);
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new XMLStreamException("Unknown DOM Node Type");
            }
        }
    }

    public void adaptDocument(Document document) throws XMLStreamException {
        this.consumer.add(new StartDocumentEvent());
        this.adapt(document.getDocumentElement());
        this.consumer.add(new EndDocumentEvent());
    }

    public void adaptNamespace(Node node, StartElementEvent startElementEvent, String string, String string2) {
        Attribute attribute = ElementFactory.createNamespaceAttribute((String)string, (String)string2);
        startElementEvent.addNamespace(attribute);
        if (string == null) {
            string = "";
        }
        this.nameSpaceTable.put(string, string2);
        this.consumer.add(new StartPrefixMappingEvent(string, string2));
    }

    public void adaptAttribute(Node node, StartElementEvent startElementEvent) throws XMLStreamException {
        String string = node.getLocalName();
        if (string == null) {
            throw new XMLStreamException("The local name of an attribute cannot be null");
        }
        if (string.equals("xmlns")) {
            this.adaptNamespace(node, startElementEvent, null, node.getNodeValue());
            return;
        }
        String string2 = node.getPrefix();
        if (string2 != null && string2.equals("xmlns")) {
            this.adaptNamespace(node, startElementEvent, node.getLocalName(), node.getNodeValue());
            return;
        }
        startElementEvent.addAttribute((Attribute)new AttributeImpl((XMLName)new Name(node.getNamespaceURI(), node.getLocalName(), node.getPrefix()), node.getNodeValue(), "CDATA"));
    }

    public void adaptElement(Node node) throws XMLStreamException {
        Object[] objectArray;
        this.nameSpaceTable.openScope();
        String string = node.getLocalName();
        if (string == null) {
            string = node.getNodeName();
        }
        StartElementEvent startElementEvent = new StartElementEvent((XMLName)new Name(node.getNamespaceURI(), string, node.getPrefix()));
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            objectArray = namedNodeMap.item(n);
            this.adaptAttribute((Node)objectArray, startElementEvent);
            ++n;
        }
        this.consumer.add(startElementEvent);
        this.recurseChildren(node);
        this.consumer.add(new EndElementEvent((XMLName)new Name(node.getNamespaceURI(), string, node.getPrefix())));
        objectArray = this.nameSpaceTable.closeScope();
        int n2 = 0;
        while (n2 < objectArray.length) {
            PrefixMapping prefixMapping = (PrefixMapping)objectArray[n2];
            if (prefixMapping.getUri() == null) {
                this.consumer.add(new EndPrefixMappingEvent(prefixMapping.getPrefix()));
            } else {
                this.consumer.add(new ChangePrefixMappingEvent(prefixMapping.getOldUri(), prefixMapping.getUri(), prefixMapping.getPrefix()));
            }
            ++n2;
        }
    }

    public void adaptDocumentFragment(DocumentFragment documentFragment) throws XMLStreamException {
        this.recurseChildren(documentFragment);
    }

    protected void recurseChildren(Node node) throws XMLStreamException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n = 0;
            while (n < nodeList.getLength()) {
                this.adapt(nodeList.item(n));
                ++n;
            }
        }
    }

    protected boolean isSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public void adaptComment(Comment comment) {
        this.consumer.add(new CommentEvent(comment.getData()));
    }

    public void adaptText(Node node) {
        boolean bl = true;
        String string = node.getNodeValue();
        int n = 0;
        while (n < string.length()) {
            if (!this.isSpace(string.charAt(n))) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            this.consumer.add(new SpaceEvent(string));
        } else {
            this.consumer.add(new CharacterDataEvent(string));
        }
    }

    public void adaptProcessingInstruction(ProcessingInstruction processingInstruction) {
        this.consumer.add(new ProcessingInstructionEvent((XMLName)new Name(processingInstruction.getNodeName()), processingInstruction.getData()));
    }

    public void adaptReference(EntityReference entityReference) throws XMLStreamException {
        this.recurseChildren(entityReference);
    }
}

