/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils;

public class UnsyncCircularQueue {
    private static final int DEFAULT_CAPACITY = 256;
    private static final int DEFAULT_MAX_CAPACITY = 65536;
    public static final int MAX_CAPACITY = 0x40000000;
    private int size = 0;
    private int producerIndex = 0;
    private int consumerIndex = 0;
    private int capacity = 1;
    private int maxCapacity = 1;
    private int bitmask;
    private Object[] q;

    public UnsyncCircularQueue() {
        this(256);
    }

    public UnsyncCircularQueue(int n) {
        this(n, 65536);
    }

    public UnsyncCircularQueue(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("Capacity greater than maximum");
        }
        if (n2 > 0x40000000) {
            throw new IllegalArgumentException("Capacity: '" + n2 + "' greater than maximum: '" + 0x40000000 + "'");
        }
        this.capacity = 1;
        while (this.capacity < n) {
            this.capacity <<= 1;
        }
        this.maxCapacity = 1;
        while (this.maxCapacity < n2) {
            this.maxCapacity <<= 1;
        }
        this.bitmask = this.capacity - 1;
        this.q = new Object[this.capacity];
    }

    private void expandQueue() {
        if (this.capacity == this.maxCapacity) {
            throw new FullQueueException(this.maxCapacity);
        }
        int n = this.capacity;
        Object[] objectArray = this.q;
        this.capacity += this.capacity;
        this.bitmask = this.capacity - 1;
        this.q = new Object[this.capacity];
        System.arraycopy(objectArray, this.consumerIndex, this.q, 0, n - this.consumerIndex);
        if (this.consumerIndex != 0) {
            System.arraycopy(objectArray, 0, this.q, n - this.consumerIndex, this.consumerIndex);
        }
        this.consumerIndex = 0;
        this.producerIndex = this.size;
    }

    public final void put(Object object) {
        if (this.size == this.capacity) {
            this.expandQueue();
        }
        ++this.size;
        this.q[this.producerIndex] = object;
        this.producerIndex = this.producerIndex + 1 & this.bitmask;
    }

    public final Object get() {
        if (this.size == 0) {
            return null;
        }
        --this.size;
        Object object = this.q[this.consumerIndex];
        this.q[this.consumerIndex] = null;
        this.consumerIndex = this.consumerIndex + 1 & this.bitmask;
        return object;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.q[this.consumerIndex];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + " - capacity: '" + this.capacity() + "' size: '" + this.size() + "'");
        if (this.size > 0) {
            stringBuffer.append(" elements:");
            int n = 0;
            while (n < this.size) {
                stringBuffer.append('\n');
                stringBuffer.append('\t');
                stringBuffer.append(this.q[this.consumerIndex + n & this.bitmask].toString());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public static class FullQueueException
    extends RuntimeException {
        private static final long serialVersionUID = 273708857498202064L;
        int capacity;

        private FullQueueException(int n) {
            this.capacity = n;
        }

        public String getMessage() {
            return "Queue exceed maximum capacity of: '" + this.capacity + "' elements";
        }
    }
}

