/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.Hashtable;
import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.Session;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;

class Function {
    private Session cSession;
    private String sFunction;
    private Method mMethod;
    private int iReturnType;
    private int iArgCount;
    private int[] iArgType;
    private boolean[] bArgNullable;
    private Object[] oArg;
    private Expression[] eArg;
    private boolean bConnection;
    private boolean isIdentityFunction;
    private static Hashtable methodCache = new Hashtable();

    Function(String string, Session session) throws SQLException {
        Object object;
        Object object2;
        Class<?>[] classArray;
        Object object3;
        int n;
        this.cSession = session;
        this.sFunction = string;
        if (string.equals("org.hsqldb.Library.identity")) {
            this.isIdentityFunction = true;
        }
        Trace.check((n = string.lastIndexOf(46)) != -1, 11, string);
        String string2 = string.substring(0, n);
        session.check("CLASS \"" + string2 + "\"", 15);
        this.mMethod = (Method)methodCache.get(string);
        if (this.mMethod == null) {
            object3 = string.substring(n + 1);
            classArray = null;
            try {
                classArray = Class.forName(string2);
            }
            catch (Exception exception) {
                throw Trace.error(42, string2 + " " + exception);
            }
            object2 = classArray.getMethods();
            n = 0;
            while (n < ((Method[])object2).length) {
                object = object2[n];
                if (((Method)object).getName().equals(object3) && Modifier.isStatic(((Method)object).getModifiers())) {
                    this.mMethod = object;
                    break;
                }
                ++n;
            }
            Trace.check(this.mMethod != null, 13, object3);
            methodCache.put(string, this.mMethod);
        }
        object3 = this.mMethod.getReturnType();
        this.iReturnType = Column.getTypeNr(((Class)object3).getName());
        classArray = this.mMethod.getParameterTypes();
        this.iArgCount = classArray.length;
        this.iArgType = new int[this.iArgCount];
        this.bArgNullable = new boolean[this.iArgCount];
        n = 0;
        while (n < classArray.length) {
            object2 = classArray[n];
            object = ((Class)object2).getName();
            if (n == 0 && ((String)object).equals("java.sql.Connection")) {
                this.bConnection = true;
            } else {
                this.iArgType[n] = Column.getTypeNr((String)object);
                this.bArgNullable[n] = !((Class)object2).isPrimitive();
            }
            ++n;
        }
        this.eArg = new Expression[this.iArgCount];
        this.oArg = new Object[this.iArgCount];
    }

    Object getValue() throws SQLException {
        Object object;
        int n = 0;
        if (this.isIdentityFunction) {
            return new Integer(this.cSession.getLastIdentity());
        }
        if (this.bConnection) {
            this.oArg[n] = this.cSession.getInternalConnection();
            ++n;
        }
        while (n < this.iArgCount) {
            Expression expression = this.eArg[n];
            object = null;
            if (expression != null) {
                object = expression.getValue(this.iArgType[n]);
            }
            if (object == null && !this.bArgNullable[n]) {
                return null;
            }
            this.oArg[n] = object;
            ++n;
        }
        try {
            return this.mMethod.invoke(null, this.oArg);
        }
        catch (Exception exception) {
            object = this.sFunction + ": " + exception.toString();
            throw Trace.getError(20, object);
        }
    }

    int getArgCount() {
        return this.iArgCount - (this.bConnection ? 1 : 0);
    }

    void resolve(TableFilter tableFilter) throws SQLException {
        int n = 0;
        while (n < this.iArgCount) {
            if (this.eArg[n] != null) {
                this.eArg[n].resolve(tableFilter);
            }
            ++n;
        }
    }

    void checkResolved() throws SQLException {
        int n = 0;
        while (n < this.iArgCount) {
            if (this.eArg[n] != null) {
                this.eArg[n].checkResolved();
            }
            ++n;
        }
    }

    int getArgType(int n) {
        return this.iArgType[n];
    }

    int getReturnType() {
        return this.iReturnType;
    }

    void setArgument(int n, Expression expression) {
        if (this.bConnection) {
            ++n;
        }
        this.eArg[n] = expression;
    }
}

