/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.MysqlDefs;
import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

public class Field {
    private static final int AUTO_INCREMENT_FLAG = 512;
    private Connection connection = null;
    private String charsetName = null;
    private String databaseName = null;
    private String defaultValue = null;
    private String fullName = null;
    private String fullNameWithDatabase = null;
    private String fullOriginalName = null;
    private String fullOriginalNameWithDatabase = null;
    private String name;
    private String originalColumnName = null;
    private String originalTableName = null;
    private String tableName;
    private byte[] buffer;
    private int charsetIndex = 0;
    private int colDecimals;
    private int databaseNameLength = -1;
    private int databaseNameStart = -1;
    private int defaultValueLength = -1;
    private int defaultValueStart = -1;
    private long length;
    private int mysqlType = -1;
    private int nameLength;
    private int nameStart;
    private int originalColumnNameLength = -1;
    private int originalColumnNameStart = -1;
    private int originalTableNameLength = -1;
    private int originalTableNameStart = -1;
    private int precisionAdjustFactor = 0;
    private int sqlType = -1;
    private int tableNameLength;
    private int tableNameStart;
    private short colFlag;

    Field(String tableName, String columnName, int jdbcType, long length) {
        this.tableName = tableName;
        this.name = columnName;
        this.length = length;
        this.sqlType = jdbcType;
        this.colFlag = 0;
        this.colDecimals = 0;
    }

    Field(Connection conn, byte[] buffer, int nameStart, int nameLength, int tableNameStart, int tableNameLength, long length, int mysqlType, short colFlag, int colDecimals) throws SQLException {
        this(conn, buffer, -1, -1, tableNameStart, tableNameLength, -1, -1, nameStart, nameLength, -1, -1, length, mysqlType, colFlag, colDecimals, -1, -1, -1);
    }

    Field(Connection conn, byte[] buffer, int databaseNameStart, int databaseNameLength, int tableNameStart, int tableNameLength, int originalTableNameStart, int originalTableNameLength, int nameStart, int nameLength, int originalColumnNameStart, int originalColumnNameLength, long length, int mysqlType, short colFlag, int colDecimals, int defaultValueStart, int defaultValueLength, int charsetIndex) throws SQLException {
        this.connection = conn;
        this.buffer = buffer;
        this.nameStart = nameStart;
        this.nameLength = nameLength;
        this.tableNameStart = tableNameStart;
        this.tableNameLength = tableNameLength;
        this.length = length;
        this.colFlag = colFlag;
        this.colDecimals = colDecimals;
        this.mysqlType = mysqlType;
        this.databaseNameStart = databaseNameStart;
        this.databaseNameLength = databaseNameLength;
        this.originalTableNameStart = originalTableNameStart;
        this.originalTableNameLength = originalTableNameLength;
        this.originalColumnNameStart = originalColumnNameStart;
        this.originalColumnNameLength = originalColumnNameLength;
        this.defaultValueStart = defaultValueStart;
        this.defaultValueLength = defaultValueLength;
        if (this.mysqlType == 252) {
            this.setBlobTypeBasedOnLength();
        }
        this.sqlType = MysqlDefs.mysqlToJavaType(this.mysqlType);
        if (this.sqlType == -6 && this.length == 1L) {
            this.sqlType = -7;
        }
        this.charsetIndex = charsetIndex;
        this.charsetName = this.connection.getCharsetNameForIndex(this.charsetIndex);
        boolean isBinary = this.isBinary();
        if (this.sqlType == -4 && !isBinary) {
            this.sqlType = -1;
        } else if (this.sqlType == -3 && !isBinary) {
            this.sqlType = 12;
        }
        if (!this.isUnsigned()) {
            switch (this.mysqlType) {
                case 0: {
                    this.precisionAdjustFactor = -1;
                    break;
                }
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                }
            }
        } else {
            switch (this.mysqlType) {
                case 4: 
                case 5: {
                    this.precisionAdjustFactor = 1;
                }
            }
        }
    }

    public boolean isAutoIncrement() {
        return (this.colFlag & 0x200) > 0;
    }

    public boolean isBinary() {
        return (this.colFlag & 0x80) > 0;
    }

    public boolean isBlob() {
        return (this.colFlag & 0x10) > 0;
    }

    public String getCharacterSet() {
        return this.charsetName;
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
        this.charsetName = this.connection.getEncoding();
    }

    public String getDatabaseName() {
        if (this.databaseName == null && this.databaseNameStart != -1 && this.databaseNameLength != -1) {
            this.databaseName = this.getStringFromBytes(this.databaseNameStart, this.databaseNameLength);
        }
        return this.databaseName;
    }

    public String getFullName() {
        if (this.fullName == null) {
            StringBuffer fullNameBuf = new StringBuffer(this.getTableName().length() + 1 + this.getName().length());
            fullNameBuf.append(this.tableName);
            fullNameBuf.append('.');
            fullNameBuf.append(this.name);
            this.fullName = fullNameBuf.toString();
            Object var1_1 = null;
        }
        return this.fullName;
    }

    public String getFullOriginalName() {
        this.getOriginalName();
        if (this.originalColumnName == null) {
            return null;
        }
        if (this.fullName == null) {
            StringBuffer fullOriginalNameBuf = new StringBuffer(this.getOriginalTableName().length() + 1 + this.getOriginalName().length());
            fullOriginalNameBuf.append(this.originalTableName);
            fullOriginalNameBuf.append('.');
            fullOriginalNameBuf.append(this.originalColumnName);
            this.fullOriginalName = fullOriginalNameBuf.toString();
            Object var1_1 = null;
        }
        return this.fullOriginalName;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isMultipleKey() {
        return (this.colFlag & 8) > 0;
    }

    public int getMysqlType() {
        return this.mysqlType;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getStringFromBytes(this.nameStart, this.nameLength);
        }
        return this.name;
    }

    public String getOriginalName() {
        if (this.originalColumnName == null && this.originalColumnNameStart != -1 && this.originalColumnNameLength != -1) {
            this.originalColumnName = this.getStringFromBytes(this.originalColumnNameStart, this.originalColumnNameLength);
        }
        return this.originalColumnName;
    }

    public String getOriginalTableName() {
        if (this.originalTableName == null && this.originalTableNameStart != -1 && this.originalTableNameLength != -1) {
            this.originalTableName = this.getStringFromBytes(this.originalTableNameStart, this.originalTableNameLength);
        }
        return this.originalTableName;
    }

    public int getPrecisionAdjustFactor() {
        return this.precisionAdjustFactor;
    }

    public boolean isPrimaryKey() {
        return (this.colFlag & 2) > 0;
    }

    public int getSQLType() {
        return this.sqlType;
    }

    public String getTable() {
        return this.getTableName();
    }

    public String getTableName() {
        if (this.tableName == null) {
            this.tableName = this.getStringFromBytes(this.tableNameStart, this.tableNameLength);
        }
        return this.tableName;
    }

    public boolean isUniqueKey() {
        return (this.colFlag & 4) > 0;
    }

    public boolean isUnsigned() {
        return (this.colFlag & 0x20) > 0;
    }

    public boolean isZeroFill() {
        return (this.colFlag & 0x40) > 0;
    }

    public String toString() {
        return this.getDatabaseName() + " . " + this.getTableName() + "(" + this.getOriginalTableName() + ") . " + this.getName() + "(" + this.getOriginalName() + ")";
    }

    int getDecimals() {
        return this.colDecimals;
    }

    boolean isNotNull() {
        return (this.colFlag & 1) > 0;
    }

    private String getStringFromBytes(int stringStart, int stringLength) {
        if (stringStart == -1 || stringLength == -1) {
            return null;
        }
        String stringVal = null;
        if (this.connection != null) {
            if (this.connection.useUnicode()) {
                String encoding = this.connection.getCharacterSetMetadata();
                if (encoding == null) {
                    encoding = this.connection.getEncoding();
                }
                if (encoding != null) {
                    SingleByteCharsetConverter converter = null;
                    if (this.connection != null) {
                        converter = this.connection.getCharsetConverter(encoding);
                    }
                    if (converter != null) {
                        stringVal = converter.toString(this.buffer, stringStart, stringLength);
                    } else {
                        byte[] stringBytes = new byte[stringLength];
                        int endIndex = stringStart + stringLength;
                        int pos = 0;
                        for (int i = stringStart; i < endIndex; ++i) {
                            stringBytes[pos++] = this.buffer[i];
                        }
                        try {
                            stringVal = new String(stringBytes, encoding);
                        }
                        catch (UnsupportedEncodingException ue) {
                            throw new RuntimeException("Unsupported character encoding '" + encoding + "'");
                        }
                    }
                } else {
                    stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
                }
            } else {
                stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
            }
        } else {
            stringVal = StringUtils.toAsciiString(this.buffer, stringStart, stringLength);
        }
        return stringVal;
    }

    private void setBlobTypeBasedOnLength() {
        if (this.length == 255L) {
            this.mysqlType = 249;
        } else if (this.length == 65535L) {
            this.mysqlType = 252;
        } else if (this.length == 0xFFFFFFL) {
            this.mysqlType = 250;
        } else if (this.length == 0xFFFFFFFFL) {
            this.mysqlType = 251;
        }
    }
}

