/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.EOFException;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.PathMap;
import org.mortbay.http.Version;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.jetty.servlet.Dispatcher;
import org.mortbay.jetty.servlet.HashSessionManager;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.servlet.ServletHttpRequest;
import org.mortbay.jetty.servlet.ServletHttpResponse;
import org.mortbay.jetty.servlet.SessionManager;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.util.ByteArrayISO8859Writer;
import org.mortbay.util.LogSupport;
import org.mortbay.util.MultiException;
import org.mortbay.util.Resource;
import org.mortbay.util.URI;

public class ServletHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$jetty$servlet$ServletHandler == null ? (class$org$mortbay$jetty$servlet$ServletHandler = ServletHandler.class$("org.mortbay.jetty.servlet.ServletHandler")) : class$org$mortbay$jetty$servlet$ServletHandler));
    public static final String __DEFAULT_SERVLET = "default";
    public static final String __J_S_CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    public static final String __J_S_ERROR_EXCEPTION = "javax.servlet.error.exception";
    public static final String __J_S_ERROR_EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static final String __J_S_ERROR_MESSAGE = "javax.servlet.error.message";
    public static final String __J_S_ERROR_REQUEST_URI = "javax.servlet.error.request_uri";
    public static final String __J_S_ERROR_SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static final String __J_S_ERROR_STATUS_CODE = "javax.servlet.error.status_code";
    private static final boolean __Slosh2Slash = File.separatorChar == '\\';
    private static String __AllowString = "GET, HEAD, POST, OPTIONS, TRACE";
    private boolean _usingCookies = true;
    private boolean _autoInitializeServlets = true;
    protected PathMap _servletMap = new PathMap();
    protected Map _nameMap = new HashMap();
    protected Map _attributes = new HashMap(3);
    protected String _formLoginPage;
    protected String _formErrorPage;
    protected SessionManager _sessionManager;
    protected transient Context _context;
    protected transient ClassLoader _loader;
    protected transient Log _contextLog;
    static /* synthetic */ Class class$org$mortbay$jetty$servlet$ServletHandler;

    public void initialize(HttpContext context) {
        SessionManager sessionManager = this.getSessionManager();
        super.initialize(context);
        this._context = new Context();
        sessionManager.initialize(this);
    }

    public void formAuthInit(String formLoginPage, String formErrorPage) {
        this._formLoginPage = formLoginPage;
        this._formErrorPage = formErrorPage;
    }

    public void setSessionManager(SessionManager sm) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        int mii = 0;
        boolean setMii = false;
        if (this._sessionManager != null) {
            mii = this._sessionManager.getMaxInactiveInterval();
            setMii = true;
            if (this.getHttpContext() != null) {
                this._sessionManager.initialize(null);
            }
        }
        this._sessionManager = sm;
        if (this._sessionManager != null) {
            if (this.getHttpContext() != null) {
                this._sessionManager.initialize(this);
            }
            if (setMii) {
                this._sessionManager.setMaxInactiveInterval(mii);
            }
        }
        this._sessionManager = sm;
    }

    public SessionManager getSessionManager() {
        if (this._sessionManager == null) {
            this._sessionManager = new HashSessionManager();
        }
        return this._sessionManager;
    }

    public ServletContext getServletContext() {
        return this._context;
    }

    public PathMap getServletMap() {
        return this._servletMap;
    }

    public boolean isUsingCookies() {
        return this._usingCookies;
    }

    public void setDynamicServletPathSpec(String dynamicServletPathSpec) {
        log.warn((Object)"setDynamicServletPathSpec is Deprecated.");
    }

    public void setDynamicInitParams(Map initParams) {
        log.warn((Object)"setDynamicInitParams is Deprecated.");
    }

    public void setServeDynamicSystemServlets(boolean b) {
        log.warn((Object)"setServeDynamicSystemServlets is Deprecated.");
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public void setUsingCookies(boolean uc) {
        this._usingCookies = uc;
    }

    public ServletHolder newServletHolder(String name, String servletClass, String forcedPath) {
        if (this._nameMap.containsKey(name)) {
            throw new IllegalArgumentException("Named servlet already exists: " + name);
        }
        ServletHolder holder = new ServletHolder(this, name, servletClass, forcedPath);
        this._nameMap.put(holder.getName(), holder);
        return holder;
    }

    public ServletHolder newServletHolder(String name, String servletClass) {
        return this.newServletHolder(name, servletClass, null);
    }

    public ServletHolder getServletHolder(String name) {
        return (ServletHolder)this._nameMap.get(name);
    }

    public ServletHolder mapPathToServlet(String pathSpec, String servletName) {
        ServletHolder holder = (ServletHolder)this._nameMap.get(servletName);
        if (!pathSpec.startsWith("/") && !pathSpec.startsWith("*")) {
            log.warn((Object)("pathSpec should start with '/' or '*' : " + pathSpec));
            pathSpec = "/" + pathSpec;
        }
        if (holder == null) {
            throw new IllegalArgumentException("Unknown servlet: " + servletName);
        }
        this._servletMap.put(pathSpec, holder);
        return holder;
    }

    public ServletHolder addServlet(String name, String pathSpec, String servletClass, String forcedPath) {
        ServletHolder holder;
        block3: {
            holder = this.getServletHolder(name);
            if (holder == null) {
                holder = this.newServletHolder(name, servletClass, forcedPath);
            }
            this.mapPathToServlet(pathSpec, name);
            if (!this.isStarted() || holder.isStarted()) break block3;
            try {
                holder.start();
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
        return holder;
    }

    public ServletHolder addServlet(String name, String pathSpec, String servletClass) {
        return this.addServlet(name, pathSpec, servletClass, null);
    }

    public ServletHolder addServlet(String pathSpec, String servletClass) {
        return this.addServlet(servletClass, pathSpec, servletClass, null);
    }

    void addServletHolder(String pathSpec, ServletHolder holder) {
        try {
            ServletHolder existing = (ServletHolder)this._nameMap.get(holder.getName());
            if (existing == null) {
                this._nameMap.put(holder.getName(), holder);
            } else if (existing != holder) {
                throw new IllegalArgumentException("Holder already exists for name: " + holder.getName());
            }
            if (this.isStarted() && !holder.isStarted()) {
                holder.start();
            }
            this._servletMap.put(pathSpec, holder);
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
    }

    public boolean isAutoInitializeServlets() {
        return this._autoInitializeServlets;
    }

    public void setAutoInitializeServlets(boolean b) {
        this._autoInitializeServlets = b;
    }

    public synchronized void start() throws Exception {
        if (this.isStarted()) {
            return;
        }
        this._contextLog = LogFactory.getLog((String)this.getHttpContext().getHttpContextName());
        if (this._contextLog == null) {
            this._contextLog = log;
        }
        if (this._sessionManager != null) {
            this._sessionManager.start();
        }
        this._loader = this.getHttpContext().getClassLoader();
        super.start();
        if (this._autoInitializeServlets) {
            this.initializeServlets();
        }
    }

    public ServletHolder[] getServlets() {
        HashSet holder_set = new HashSet(this._nameMap.size());
        holder_set.addAll(this._nameMap.values());
        Object[] holders = holder_set.toArray(new ServletHolder[holder_set.size()]);
        Arrays.sort(holders);
        return holders;
    }

    public void initializeServlets() throws Exception {
        MultiException mx = new MultiException();
        ServletHolder[] holders = this.getServlets();
        int i = 0;
        while (i < holders.length) {
            try {
                holders[i].start();
            }
            catch (Exception e) {
                log.debug((Object)"EXCEPTION ", (Throwable)e);
                mx.add(e);
            }
            ++i;
        }
        mx.ifExceptionThrow();
    }

    public synchronized void stop() throws InterruptedException {
        ServletHolder[] holders = this.getServlets();
        super.stop();
        int i = holders.length;
        while (i-- > 0) {
            try {
                if (!holders[i].isStarted()) continue;
                holders[i].stop();
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
        this._sessionManager.stop();
        this._attributes.clear();
        this._loader = null;
    }

    HttpSession getHttpSession(String id) {
        return this._sessionManager.getHttpSession(id);
    }

    HttpSession newHttpSession(HttpServletRequest request) {
        return this._sessionManager.newHttpSession(request);
    }

    void setSessionInactiveInterval(int seconds) {
        this._sessionManager.setMaxInactiveInterval(seconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String pathInContext, String pathParams, HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        ServletHolder servletHolder;
        if (!this.isStarted() && this._context == null) {
            return;
        }
        if ("TRACE".equals(httpRequest.getMethod())) {
            this.handleTrace(httpRequest, httpResponse);
            return;
        }
        ServletHttpRequest request = (ServletHttpRequest)httpRequest.getWrapper();
        ServletHttpResponse response = (ServletHttpResponse)httpResponse.getWrapper();
        if (request == null) {
            request = new ServletHttpRequest(this, pathInContext, httpRequest);
            response = new ServletHttpResponse(request, httpResponse);
            httpRequest.setWrapper(request);
            httpResponse.setWrapper(response);
        } else {
            request.recycle(this, pathInContext);
            response.recycle();
        }
        Map.Entry servlet = this.getHolderEntry(pathInContext);
        ServletHolder servletHolder2 = servletHolder = servlet == null ? null : (ServletHolder)servlet.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("servlet=" + servlet));
        }
        try {
            if (servlet != null) {
                String servletPathSpec = (String)servlet.getKey();
                request.setServletPaths(PathMap.pathMatch(servletPathSpec, pathInContext), PathMap.pathInfo(servletPathSpec, pathInContext), servletHolder);
            }
            request.setSessionId(pathParams);
            HttpSession session = request.getSession(false);
            if (session != null) {
                ((SessionManager.Session)session).access();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("session=" + session));
            }
            if (servletHolder != null) {
                this.dispatch(pathInContext, request, response, servletHolder);
            }
        }
        catch (Exception e) {
            log.debug((Object)"EXCEPTION ", (Throwable)e);
            Throwable th = e;
            if (e instanceof ServletException) {
                Throwable root = ((ServletException)e).getRootCause();
                while (root instanceof ServletException) {
                    root = ((ServletException)e).getRootCause();
                }
                if (root instanceof HttpException || root instanceof EOFException) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Extracting root cause from ", (Throwable)e);
                    }
                    th = root;
                }
            }
            if (th instanceof HttpException) {
                throw (HttpException)th;
            }
            if (th instanceof EOFException) {
                throw (IOException)th;
            }
            if (log.isDebugEnabled() || !(th instanceof IOException)) {
                this._contextLog.warn((Object)(httpRequest.getURI() + ": "), th);
                if (log.isDebugEnabled()) {
                    log.warn((Object)(httpRequest.getURI() + ": "), th);
                    log.debug((Object)httpRequest);
                }
            }
            httpResponse.getHttpConnection().forceClose();
            if (!httpResponse.isCommitted()) {
                request.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, th.getClass());
                request.setAttribute(__J_S_ERROR_EXCEPTION, th);
                response.sendError(th instanceof UnavailableException ? 503 : 500, e.getMessage());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Response already committed for handling " + th));
            }
        }
        catch (Error e) {
            log.warn((Object)("Error for " + httpRequest.getURI()), (Throwable)e);
            if (log.isDebugEnabled()) {
                log.debug((Object)httpRequest);
            }
            httpResponse.getHttpConnection().forceClose();
            if (!httpResponse.isCommitted()) {
                request.setAttribute(__J_S_ERROR_EXCEPTION_TYPE, e.getClass());
                request.setAttribute(__J_S_ERROR_EXCEPTION, e);
                response.sendError(500, e.getMessage());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Response already committed for handling ", (Throwable)e);
            }
        }
        finally {
            if (servletHolder != null) {
                response.flushBuffer();
                if (!httpRequest.isHandled()) {
                    new Throwable().printStackTrace();
                }
            }
        }
    }

    protected void dispatch(String pathInContext, HttpServletRequest request, HttpServletResponse response, ServletHolder servletHolder) throws ServletException, UnavailableException, IOException {
        servletHolder.handle((ServletRequest)request, (ServletResponse)response);
    }

    public Map.Entry getHolderEntry(String pathInContext) {
        return this._servletMap.getMatch(pathInContext);
    }

    public Set getResourcePaths(String uriInContext) {
        try {
            uriInContext = URI.canonicalPath(uriInContext);
            if (uriInContext == null) {
                return Collections.EMPTY_SET;
            }
            Resource resource = this.getHttpContext().getResource(uriInContext);
            if (resource == null || !resource.isDirectory()) {
                return Collections.EMPTY_SET;
            }
            String[] contents = resource.list();
            if (contents == null || contents.length == 0) {
                return Collections.EMPTY_SET;
            }
            HashSet<String> set = new HashSet<String>(contents.length * 2);
            int i = 0;
            while (i < contents.length) {
                set.add(URI.addPaths(uriInContext, contents[i]));
                ++i;
            }
            return set;
        }
        catch (Exception e) {
            e.printStackTrace();
            LogSupport.ignore(log, e);
            return Collections.EMPTY_SET;
        }
    }

    public URL getResource(String uriInContext) throws MalformedURLException {
        try {
            Resource resource = this.getHttpContext().getResource(uriInContext);
            if (resource != null && resource.exists()) {
                return resource.getURL();
            }
        }
        catch (IllegalArgumentException e) {
            LogSupport.ignore(log, e);
        }
        catch (MalformedURLException e) {
            throw e;
        }
        catch (IOException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        return null;
    }

    public InputStream getResourceAsStream(String uriInContext) {
        try {
            Resource resource = this.getHttpContext().getResource(uriInContext);
            if (resource != null) {
                return resource.getInputStream();
            }
            URL url = this.getResource(uriInContext = URI.canonicalPath(uriInContext));
            if (url != null) {
                return url.openStream();
            }
        }
        catch (MalformedURLException e) {
            LogSupport.ignore(log, e);
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
        return null;
    }

    public String getRealPath(String path) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getRealPath of " + path + " in " + this));
        }
        if (__Slosh2Slash) {
            path = path.replace('\\', '/');
        }
        if ((path = URI.canonicalPath(path)) == null) {
            return null;
        }
        Resource baseResource = this.getHttpContext().getBaseResource();
        if (baseResource == null) {
            return null;
        }
        try {
            Resource resource = baseResource.addPath(path);
            File file = resource.getFile();
            return file == null ? null : file.getAbsolutePath();
        }
        catch (IOException e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
            return null;
        }
    }

    public RequestDispatcher getRequestDispatcher(String uriInContext) {
        if (uriInContext == null) {
            return null;
        }
        if (!uriInContext.startsWith("/")) {
            uriInContext = "/" + uriInContext;
        }
        try {
            String pathInContext;
            Map.Entry entry;
            String query = null;
            int q = 0;
            q = uriInContext.indexOf(63);
            if (q > 0) {
                query = uriInContext.substring(q + 1);
                uriInContext = uriInContext.substring(0, q);
            }
            if ((q = uriInContext.indexOf(59)) > 0) {
                uriInContext = uriInContext.substring(0, q);
            }
            if ((entry = this.getHolderEntry(pathInContext = URI.canonicalPath(URI.decodePath(uriInContext)))) != null) {
                return new Dispatcher(this, uriInContext, pathInContext, query, entry);
            }
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
        }
        return null;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        if (name == null || name.length() == 0) {
            name = __DEFAULT_SERVLET;
        }
        try {
            return new Dispatcher(this, name);
        }
        catch (Exception e) {
            LogSupport.ignore(log, e);
            return null;
        }
    }

    void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Not Found " + request.getRequestURI()));
        }
        if ((method = request.getMethod()).equals("GET") || method.equals("HEAD") || method.equals("POST")) {
            response.sendError(404);
        } else if (method.equals("TRACE")) {
            this.handleTrace(request, response);
        } else if (method.equals("OPTIONS")) {
            this.handleOptions(request, response);
        } else {
            response.setHeader("Allow", __AllowString);
            response.sendError(405);
        }
    }

    void handleTrace(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Content-Type", "message/http");
        ServletOutputStream out = response.getOutputStream();
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer();
        writer.write(request.toString());
        writer.flush();
        response.setIntHeader("Content-Length", writer.size());
        writer.writeTo((OutputStream)out);
        out.flush();
    }

    void handleOptions(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if ("*".equals(request.getRequestURI())) {
            response.setIntHeader("Content-Length", 0);
            response.setHeader("Allow", __AllowString);
            response.flushBuffer();
        } else {
            response.sendError(404);
        }
    }

    String getErrorPage(int status, ServletHttpRequest request) {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Context
    implements ServletContext {
        Context() {
        }

        ServletHandler getServletHandler() {
            return ServletHandler.this;
        }

        public ServletContext getContext(String uri) {
            ServletHandler handler = (ServletHandler)ServletHandler.this.getHttpContext().getHttpServer().findHandler(class$org$mortbay$jetty$servlet$ServletHandler == null ? (class$org$mortbay$jetty$servlet$ServletHandler = ServletHandler.class$("org.mortbay.jetty.servlet.ServletHandler")) : class$org$mortbay$jetty$servlet$ServletHandler, uri, ServletHandler.this.getHttpContext().getVirtualHosts());
            if (handler != null) {
                return handler.getServletContext();
            }
            return null;
        }

        public int getMajorVersion() {
            return 2;
        }

        public int getMinorVersion() {
            return 4;
        }

        public String getMimeType(String file) {
            return ServletHandler.this.getHttpContext().getMimeByExtension(file);
        }

        public Set getResourcePaths(String uriInContext) {
            return ServletHandler.this.getResourcePaths(uriInContext);
        }

        public URL getResource(String uriInContext) throws MalformedURLException {
            return ServletHandler.this.getResource(uriInContext);
        }

        public InputStream getResourceAsStream(String uriInContext) {
            return ServletHandler.this.getResourceAsStream(uriInContext);
        }

        public String getRealPath(String path) {
            return ServletHandler.this.getRealPath(path);
        }

        public RequestDispatcher getRequestDispatcher(String uriInContext) {
            return ServletHandler.this.getRequestDispatcher(uriInContext);
        }

        public RequestDispatcher getNamedDispatcher(String name) {
            return ServletHandler.this.getNamedDispatcher(name);
        }

        public Servlet getServlet(String name) {
            return null;
        }

        public Enumeration getServlets() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public Enumeration getServletNames() {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }

        public void log(String msg) {
            ServletHandler.this._contextLog.info((Object)msg);
        }

        public void log(Exception e, String msg) {
            ServletHandler.this._contextLog.warn((Object)msg, (Throwable)e);
        }

        public void log(String msg, Throwable th) {
            ServletHandler.this._contextLog.warn((Object)msg, th);
        }

        public String getServerInfo() {
            return Version.__VersionImpl;
        }

        public String getInitParameter(String param) {
            return ServletHandler.this.getHttpContext().getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return ServletHandler.this.getHttpContext().getInitParameterNames();
        }

        public Object getAttribute(String name) {
            if (ServletHandler.__J_S_CONTEXT_TEMPDIR.equals(name)) {
                Object t = ServletHandler.this.getHttpContext().getAttribute(ServletHandler.__J_S_CONTEXT_TEMPDIR);
                if (t instanceof File) {
                    return (File)t;
                }
                return ServletHandler.this.getHttpContext().getTempDirectory();
            }
            if (ServletHandler.this._attributes.containsKey(name)) {
                return ServletHandler.this._attributes.get(name);
            }
            return ServletHandler.this.getHttpContext().getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            if (ServletHandler.this._attributes.size() == 0) {
                return ServletHandler.this.getHttpContext().getAttributeNames();
            }
            HashSet set = new HashSet(ServletHandler.this._attributes.keySet());
            Enumeration e = ServletHandler.this.getHttpContext().getAttributeNames();
            while (e.hasMoreElements()) {
                set.add(e.nextElement());
            }
            return Collections.enumeration(set);
        }

        public void setAttribute(String name, Object value) {
            ServletHandler.this._attributes.put(name, value);
        }

        public void removeAttribute(String name) {
            ServletHandler.this._attributes.put(name, null);
        }

        public String getServletContextName() {
            if (ServletHandler.this.getHttpContext() instanceof WebApplicationContext) {
                return ((WebApplicationContext)ServletHandler.this.getHttpContext()).getDisplayName();
            }
            return null;
        }

        public String toString() {
            return "ServletContext[" + ServletHandler.this.getHttpContext() + "]";
        }
    }
}

