/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.http.Authenticator;
import org.mortbay.http.BasicAuthenticator;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.UserRealm;
import org.mortbay.util.LazyList;

public class SecurityConstraint
implements Cloneable,
Serializable {
    private static Log log = LogFactory.getLog((Class)(class$org$mortbay$http$SecurityConstraint == null ? (class$org$mortbay$http$SecurityConstraint = SecurityConstraint.class$("org.mortbay.http.SecurityConstraint")) : class$org$mortbay$http$SecurityConstraint));
    public static final String __BASIC_AUTH = "BASIC";
    public static final String __FORM_AUTH = "FORM";
    public static final String __DIGEST_AUTH = "DIGEST";
    public static final String __CERT_AUTH = "CLIENT_CERT";
    public static final String __CERT_AUTH2 = "CLIENT-CERT";
    public static final int DC_UNSET = -1;
    public static final int DC_NONE = 0;
    public static final int DC_INTEGRAL = 1;
    public static final int DC_CONFIDENTIAL = 2;
    public static final String NONE = "NONE";
    public static final String ANY_ROLE = "*";
    public static final Nobody __NOBODY = new Nobody();
    private String _name;
    private Object _methods;
    private List _umMethods;
    private Object _roles;
    private List _umRoles;
    private int _dataConstraint = -1;
    private boolean _anyRole = false;
    private boolean _authenticate = false;
    static /* synthetic */ Class class$org$mortbay$http$SecurityConstraint;

    public SecurityConstraint() {
    }

    public SecurityConstraint(String name, String role) {
        this.setName(name);
        this.addRole(role);
    }

    public void setName(String name) {
        this._name = name;
    }

    public synchronized void addMethod(String method) {
        this._methods = LazyList.add(this._methods, method);
    }

    public List getMethods() {
        if (this._umMethods == null && this._methods != null) {
            this._umMethods = Collections.unmodifiableList(LazyList.getList(this._methods));
        }
        return this._umMethods;
    }

    public boolean forMethod(String method) {
        if (this._methods == null) {
            return true;
        }
        int i = 0;
        while (i < LazyList.size(this._methods)) {
            if (LazyList.get(this._methods, i).equals(method)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void addRole(String role) {
        this._authenticate = true;
        if (ANY_ROLE.equals(role)) {
            this._roles = null;
            this._umRoles = null;
            this._anyRole = true;
        } else if (!this._anyRole) {
            this._roles = LazyList.add(this._roles, role);
        }
    }

    public boolean isAnyRole() {
        return this._anyRole;
    }

    public List getRoles() {
        if (this._umRoles == null && this._roles != null) {
            this._umRoles = Collections.unmodifiableList(LazyList.getList(this._roles));
        }
        return this._umRoles;
    }

    public boolean hasRole(String role) {
        return LazyList.contains(this._roles, role);
    }

    public void setAuthenticate(boolean authenticate) {
        this._authenticate = authenticate;
    }

    public boolean getAuthenticate() {
        return this._authenticate;
    }

    public boolean isForbidden() {
        return this._authenticate && !this._anyRole && LazyList.size(this._roles) == 0;
    }

    public void setDataConstraint(int c) {
        if (c < 0 || c > 2) {
            throw new IllegalArgumentException("Constraint out of range");
        }
        this._dataConstraint = c;
    }

    public int getDataConstraint() {
        return this._dataConstraint;
    }

    public boolean hasDataConstraint() {
        return this._dataConstraint >= 0;
    }

    public Object clone() {
        SecurityConstraint sc = new SecurityConstraint();
        sc._name = this._name;
        sc._dataConstraint = this._dataConstraint;
        sc._anyRole = this._anyRole;
        sc._authenticate = this._authenticate;
        sc._methods = LazyList.clone(this._methods);
        sc._roles = LazyList.clone(this._roles);
        return sc;
    }

    public String toString() {
        return "SC{" + this._name + "," + this._methods + "," + (this._anyRole ? ANY_ROLE : (this._roles == null ? "-" : this._roles.toString())) + "," + (this._dataConstraint == 0 ? "NONE}" : (this._dataConstraint == 1 ? "INTEGRAL}" : "CONFIDENTIAL}"));
    }

    public static boolean check(List constraints, Authenticator authenticator, UserRealm realm, String pathInContext, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        int dataConstraint = 0;
        Object roles = null;
        boolean unauthenticated = false;
        boolean forbidden = false;
        int c = 0;
        while (c < constraints.size()) {
            SecurityConstraint sc = (SecurityConstraint)constraints.get(c);
            if (sc.forMethod(request.getMethod())) {
                if (dataConstraint > -1 && sc.hasDataConstraint()) {
                    if (sc.getDataConstraint() > dataConstraint) {
                        dataConstraint = sc.getDataConstraint();
                    }
                } else {
                    dataConstraint = -1;
                }
                if (!unauthenticated && !forbidden) {
                    if (sc.getAuthenticate()) {
                        if (sc.isAnyRole()) {
                            roles = ANY_ROLE;
                        } else {
                            List scr = sc.getRoles();
                            if (scr == null || scr.size() == 0) {
                                forbidden = true;
                                break;
                            }
                            if (roles != ANY_ROLE) {
                                roles = LazyList.addCollection(roles, scr);
                            }
                        }
                    } else {
                        unauthenticated = true;
                    }
                }
            }
            ++c;
        }
        if (forbidden) {
            HttpContext.sendContextError(response, 403, null);
            return false;
        }
        if (dataConstraint > 0) {
            HttpConnection connection = request.getHttpConnection();
            HttpListener listener = connection.getListener();
            switch (dataConstraint) {
                case 1: {
                    if (listener.isIntegral(connection)) break;
                    if (listener.getIntegralPort() > 0) {
                        String url = listener.getIntegralScheme() + "://" + request.getHost() + ":" + listener.getIntegralPort() + request.getPath();
                        if (request.getQuery() != null) {
                            url = url + "?" + request.getQuery();
                        }
                        response.setContentLength(0);
                        response.sendRedirect(url);
                    } else {
                        HttpContext.sendContextError(response, 403, null);
                    }
                    return false;
                }
                case 2: {
                    if (listener.isConfidential(connection)) break;
                    if (listener.getConfidentialPort() > 0) {
                        String url = listener.getConfidentialScheme() + "://" + request.getHost() + ":" + listener.getConfidentialPort() + request.getPath();
                        if (request.getQuery() != null) {
                            url = url + "?" + request.getQuery();
                        }
                        response.setContentLength(0);
                        response.sendRedirect(url);
                    } else {
                        HttpContext.sendContextError(response, 403, null);
                    }
                    return false;
                }
                default: {
                    HttpContext.sendContextError(response, 403, null);
                    return false;
                }
            }
        }
        if (!unauthenticated && roles != null) {
            if (realm == null) {
                HttpContext.sendContextError(response, 500, "Configuration error");
                return false;
            }
            Principal user = null;
            if (request.getAuthType() != null && request.getAuthUser() != null) {
                user = request.getUserPrincipal();
                if (user == null) {
                    user = realm.authenticate(request.getAuthUser(), null, request);
                }
                if (user == null && authenticator != null) {
                    user = authenticator.authenticate(realm, pathInContext, request, response);
                }
            } else if (authenticator != null) {
                user = authenticator.authenticate(realm, pathInContext, request, response);
            } else {
                log.warn((Object)("Mis-configured Authenticator for " + request.getPath()));
                HttpContext.sendContextError(response, 500, "Configuration error");
            }
            if (user == null) {
                return false;
            }
            if (user == __NOBODY) {
                return true;
            }
            if (roles != ANY_ROLE) {
                boolean inRole = false;
                int r = LazyList.size(roles);
                while (r-- > 0) {
                    if (!realm.isUserInRole(user, (String)LazyList.get(roles, r))) continue;
                    inRole = true;
                    break;
                }
                if (!inRole) {
                    log.warn((Object)("AUTH FAILURE: role for " + user.getName()));
                    if (__BASIC_AUTH.equalsIgnoreCase(authenticator.getAuthMethod())) {
                        ((BasicAuthenticator)authenticator).sendChallenge(realm, response);
                    } else {
                        HttpContext.sendContextError(response, 403, "User not in required role");
                    }
                    return false;
                }
            }
        } else {
            request.setUserPrincipal(HttpRequest.__NOT_CHECKED);
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Nobody
    implements Principal {
        public String getName() {
            return "Nobody";
        }
    }
}

