/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.influxdb;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.ice4j.ice.Agent;
import org.ice4j.ice.CandidatePair;
import org.ice4j.ice.Component;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.IceProcessingState;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaStreamStats;
import org.jitsi.util.ExecutorUtils;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.TransportManager;
import org.jitsi.videobridge.VideoChannel;
import org.jitsi.videobridge.eventadmin.Event;
import org.jitsi.videobridge.eventadmin.EventHandler;
import org.jitsi.videobridge.influxdb.InfluxDBEvent;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class LoggingHandler
implements EventHandler {
    private static final String[] CONFERENCE_CREATED_COLUMNS = new String[]{"conference_id", "focus"};
    private static final String[] CONFERENCE_EXPIRED_COLUMNS = new String[]{"conference_id"};
    private static final String[] CONTENT_CREATED_COLUMNS = new String[]{"name", "conference_id"};
    private static final String[] CONTENT_EXPIRED_COLUMNS = new String[]{"name", "conference_id"};
    private static final String[] CHANNEL_CREATED_COLUMNS = new String[]{"channel_id", "content_name", "conference_id", "endpoint_id", "lastn"};
    private static final String[] RTP_CHANNEL_EXPIRED_COLUMNS = new String[]{"channel_id", "content_name", "conference_id", "endpoint_id", "stats.local_ip", "stats.local_port", "stats.remote_ip", "stats.remote_port", "stats.nb_received_bytes", "stats.nb_sent_bytes", "stats.nb_received_packets", "stats.nb_received_packets_lost", "stats.nb_sent_packets", "stats.nb_sent_packets_lost", "stats.min_download_jitter_ms", "stats.max_download_jitter_ms", "stats.avg_download_jitter_ms", "stats.min_upload_jitter_ms", "stats.max_upload_jitter_ms", "stats.avg_upload_jitter_ms"};
    private static final String[] CHANNEL_EXPIRED_COLUMNS = new String[]{"channel_id", "content_name", "conference_id", "endpoint_id"};
    private static final String[] TRANSPORT_CREATED_COLUMNS = new String[]{"hash_code", "conference_id", "num_components", "ufrag", "is_controlling"};
    private static final String[] TRANSPORT_CHANNEL_ADDED_COLUMNS = new String[]{"hash_code", "conference_id", "channel_id"};
    private static final String[] TRANSPORT_CHANNEL_REMOVED_COLUMNS = new String[]{"hash_code", "conference_id", "channel_id"};
    private static final String[] TRANSPORT_CONNECTED_COLUMNS = new String[]{"hash_code", "conference_id", "selected_pairs"};
    private static final String[] TRANSPORT_STATE_CHANGED_COLUMNS = new String[]{"hash_code", "conference_id", "old_state", "new_state"};
    private static final String[] ENDPOINT_CREATED_COLUMNS = new String[]{"conference_id", "endpoint_id"};
    private static final String[] ENDPOINT_DISPLAY_NAME_COLUMNS = new String[]{"conference_id", "endpoint_id", "display_name"};
    public static final String ENABLED_PNAME = "org.jitsi.videobridge.log.INFLUX_DB_ENABLED";
    public static final String URL_BASE_PNAME = "org.jitsi.videobridge.log.INFLUX_URL_BASE";
    public static final String DATABASE_PNAME = "org.jitsi.videobridge.log.INFLUX_DATABASE";
    public static final String USER_PNAME = "org.jitsi.videobridge.log.INFLUX_USER";
    public static final String PASS_PNAME = "org.jitsi.videobridge.log.INFLUX_PASS";
    private static final Logger logger = Logger.getLogger(LoggingHandler.class);
    private final Executor executor = ExecutorUtils.newCachedThreadPool((boolean)true, (String)LoggingHandler.class.getName());
    private final URL url;

    public LoggingHandler(ConfigurationService cfg) throws Exception {
        if (cfg == null) {
            throw new NullPointerException("cfg");
        }
        String s = "Required property not set: ";
        String urlBase = cfg.getString(URL_BASE_PNAME, null);
        if (urlBase == null) {
            throw new Exception(s + URL_BASE_PNAME);
        }
        String database = cfg.getString(DATABASE_PNAME, null);
        if (database == null) {
            throw new Exception(s + DATABASE_PNAME);
        }
        String user = cfg.getString(USER_PNAME, null);
        if (user == null) {
            throw new Exception(s + USER_PNAME);
        }
        String pass = cfg.getString(PASS_PNAME, null);
        if (pass == null) {
            throw new Exception(s + PASS_PNAME);
        }
        String urlStr = urlBase + "/db/" + database + "/series?u=" + user + "&p=" + pass;
        this.url = new URL(urlStr);
        logger.info((Object)("Initialized InfluxDBLoggingService for " + urlBase + ", database \"" + database + "\""));
    }

    protected void logEvent(InfluxDBEvent e) {
        boolean useLocalTime = e.useLocalTime();
        long now = System.currentTimeMillis();
        boolean multipoint = false;
        int pointCount = 1;
        JSONArray columns = new JSONArray();
        JSONArray points = new JSONArray();
        Object[] values = e.getValues();
        if (useLocalTime) {
            columns.add((Object)"time");
        }
        Collections.addAll(columns, e.getColumns());
        if (values[0] instanceof Object[]) {
            multipoint = true;
            pointCount = values.length;
        }
        if (multipoint) {
            for (int i = 0; i < pointCount; ++i) {
                if (!(values[i] instanceof Object[])) continue;
                JSONArray point = new JSONArray();
                if (useLocalTime) {
                    point.add((Object)now);
                }
                Collections.addAll(point, (Object[])values[i]);
                points.add((Object)point);
            }
        } else {
            JSONArray point = new JSONArray();
            if (useLocalTime) {
                point.add((Object)now);
            }
            Collections.addAll(point, values);
            points.add((Object)point);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)e.getName());
        jsonObject.put((Object)"columns", (Object)columns);
        jsonObject.put((Object)"points", (Object)points);
        JSONArray jsonArray = new JSONArray();
        jsonArray.add((Object)jsonObject);
        final String jsonString = jsonArray.toJSONString();
        this.executor.execute(new Runnable(){

            public void run() {
                LoggingHandler.this.sendPost(jsonString);
            }
        });
    }

    private void sendPost(String s) {
        try {
            HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-type", "application/json");
            connection.setDoOutput(true);
            DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
            outputStream.writeBytes(s);
            outputStream.flush();
            outputStream.close();
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("HTTP response code: " + responseCode);
            }
        }
        catch (IOException ioe) {
            logger.info((Object)("Failed to post to influxdb: " + ioe));
        }
    }

    private void conferenceCreated(Conference conference) {
        if (conference == null) {
            logger.debug((Object)"Could not log conference created event because the conference is null.");
            return;
        }
        String focus = conference.getFocus();
        this.logEvent(new InfluxDBEvent("conference_created", CONFERENCE_CREATED_COLUMNS, new Object[]{conference.getID(), focus != null ? focus : "null"}));
    }

    private void conferenceExpired(Conference conference) {
        if (conference == null) {
            logger.debug((Object)"Could not log conference expired event because the conference is null.");
            return;
        }
        this.logEvent(new InfluxDBEvent("conference_expired", CONFERENCE_EXPIRED_COLUMNS, new Object[]{conference.getID()}));
    }

    private void endpointCreated(Endpoint endpoint) {
        if (endpoint == null) {
            logger.debug((Object)"Could not log endpoint created event because the endpoint is null.");
            return;
        }
        Conference conference = endpoint.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log endpoint created event because the conference is null.");
            return;
        }
        this.logEvent(new InfluxDBEvent("endpoint_created", ENDPOINT_CREATED_COLUMNS, new Object[]{conference.getID(), endpoint.getID()}));
    }

    private void endpointDisplayNameChanged(Endpoint endpoint) {
        if (endpoint == null) {
            logger.debug((Object)"Could not log endpoint display name changed event because the endpoint is null.");
            return;
        }
        Conference conference = endpoint.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log endpoint display name changed  event because the conference is null.");
            return;
        }
        this.logEvent(new InfluxDBEvent("endpoint_display_name", ENDPOINT_DISPLAY_NAME_COLUMNS, new Object[]{conference.getID(), endpoint.getID(), endpoint.getDisplayName()}));
    }

    private void contentCreated(Content content) {
        if (content == null) {
            logger.debug((Object)"Could not log content created event because the content is null.");
            return;
        }
        Conference conference = content.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log content created event because the conference is null.");
            return;
        }
        this.logEvent(new InfluxDBEvent("content_created", CONTENT_CREATED_COLUMNS, new Object[]{content.getName(), conference.getID()}));
    }

    private void contentExpired(Content content) {
        if (content == null) {
            logger.debug((Object)"Could not log content expired event because the content is null.");
            return;
        }
        Conference conference = content.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log content expired event because the conference is null.");
            return;
        }
        this.logEvent(new InfluxDBEvent("content_expired", CONTENT_EXPIRED_COLUMNS, new Object[]{content.getName(), conference.getID()}));
    }

    private void transportChannelAdded(Channel channel) {
        TransportManager transportManager = channel.getTransportManager();
        if (transportManager == null) {
            logger.error((Object)"Could not log the transport channel added event: the transport manager is null.");
            return;
        }
        Content content = channel.getContent();
        if (content == null) {
            logger.debug((Object)"Could not log the transport channel added event because the content is null.");
            return;
        }
        Conference conference = content.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log the transport channel added event because the conference is null.");
            return;
        }
        this.logEvent(new InfluxDBEvent("transport_channel_added", TRANSPORT_CHANNEL_ADDED_COLUMNS, new Object[]{String.valueOf(transportManager.hashCode()), conference.getID(), channel.getID()}));
    }

    private void transportChannelRemoved(Channel channel) {
        TransportManager transportManager = channel.getTransportManager();
        if (transportManager == null) {
            logger.error((Object)"Could not log the transport channel removed event: the transport manager is null.");
            return;
        }
        Content content = channel.getContent();
        if (content == null) {
            logger.debug((Object)"Could not log the transport channel removed event because the content is null.");
            return;
        }
        Conference conference = content.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log the transport channel removed event because the conference is null.");
            return;
        }
        this.logEvent(new InfluxDBEvent("transport_channel_removed", TRANSPORT_CHANNEL_REMOVED_COLUMNS, new Object[]{String.valueOf(transportManager.hashCode()), conference.getID(), channel.getID()}));
    }

    private void transportStateChanged(IceUdpTransportManager transportManager, IceProcessingState oldState, IceProcessingState newState) {
        Conference conference = transportManager.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log the transport state changed event because the conference is null.");
            return;
        }
        this.logEvent(new InfluxDBEvent("transport_state_changed", TRANSPORT_STATE_CHANGED_COLUMNS, new Object[]{String.valueOf(transportManager.hashCode()), conference.getID(), oldState == null ? "null" : oldState.toString(), newState == null ? "null" : newState.toString()}));
    }

    private void transportCreated(IceUdpTransportManager transportManager) {
        Conference conference = transportManager.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log the transport created event because the conference is null.");
            return;
        }
        Agent agent = transportManager.getAgent();
        if (agent == null) {
            logger.debug((Object)"Could not log the transport created event because the agent is null.");
            return;
        }
        this.logEvent(new InfluxDBEvent("transport_created", TRANSPORT_CREATED_COLUMNS, new Object[]{String.valueOf(transportManager.hashCode()), conference.getID(), transportManager.getNumComponents(), agent.getLocalUfrag(), Boolean.valueOf(transportManager.isControlling()).toString()}));
    }

    private void transportConnected(IceUdpTransportManager transportManager) {
        Conference conference = transportManager.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log the transport connected event because the conference is null.");
            return;
        }
        IceMediaStream iceStream = transportManager.getIceStream();
        if (iceStream == null) {
            logger.debug((Object)"Could not log the transport connected event because the iceStream is null.");
            return;
        }
        StringBuilder s = new StringBuilder();
        for (Component component : iceStream.getComponents()) {
            CandidatePair pair = component.getSelectedPair();
            if (pair == null) continue;
            LocalCandidate localCandidate = pair.getLocalCandidate();
            RemoteCandidate remoteCandidate = pair.getRemoteCandidate();
            s.append((Object)(localCandidate == null ? "unknown" : localCandidate.getTransportAddress())).append(" -> ").append((Object)(remoteCandidate == null ? "unknown" : remoteCandidate.getTransportAddress())).append("; ");
        }
        this.logEvent(new InfluxDBEvent("transport_connected", TRANSPORT_CONNECTED_COLUMNS, new Object[]{String.valueOf(transportManager.hashCode()), conference.getID(), s.toString()}));
    }

    private void channelCreated(Channel channel) {
        if (channel == null) {
            logger.debug((Object)"Could not log the channel created event because the channel is null.");
            return;
        }
        Content content = channel.getContent();
        if (content == null) {
            logger.debug((Object)"Could not log the channel created event because the content is null.");
            return;
        }
        Conference conference = content.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log the channel created event because the conference is null.");
            return;
        }
        String endpointID = "";
        Endpoint endpoint = channel.getEndpoint();
        if (endpoint != null) {
            endpointID = endpoint.getID();
        }
        int lastN = -1;
        if (channel instanceof VideoChannel) {
            lastN = ((VideoChannel)channel).getLastN();
        }
        this.logEvent(new InfluxDBEvent("channel_created", CHANNEL_CREATED_COLUMNS, new Object[]{channel.getID(), content.getName(), conference.getID(), endpointID, lastN}));
    }

    private void channelExpired(Channel channel) {
        Endpoint endpoint;
        String endpointID;
        RtpChannel rtpChannel;
        MediaStream stream;
        if (channel == null) {
            logger.debug((Object)"Could not log the channel expired event because the channel is null.");
            return;
        }
        Content content = channel.getContent();
        if (content == null) {
            logger.debug((Object)"Could not log the channel expired event because the content is null.");
            return;
        }
        Conference conference = content.getConference();
        if (conference == null) {
            logger.debug((Object)"Could not log the channel expired event because the conference is null.");
            return;
        }
        MediaStreamStats stats = null;
        if (channel instanceof RtpChannel && (stream = (rtpChannel = (RtpChannel)channel).getStream()) != null) {
            stats = stream.getMediaStreamStats();
        }
        String string = endpointID = (endpoint = channel.getEndpoint()) == null ? "" : endpoint.getID();
        if (stats != null) {
            Object[] values = new Object[]{channel.getID(), content.getName(), conference.getID(), endpointID, stats.getLocalIPAddress(), stats.getLocalPort(), stats.getRemoteIPAddress(), stats.getRemotePort(), stats.getNbReceivedBytes(), stats.getNbSentBytes(), stats.getNbPacketsReceived() + stats.getDownloadNbPacketLost(), stats.getDownloadNbPacketLost(), stats.getNbPacketsSent(), stats.getUploadNbPacketLost(), stats.getMinDownloadJitterMs(), stats.getMaxDownloadJitterMs(), stats.getAvgDownloadJitterMs(), stats.getMinUploadJitterMs(), stats.getMaxUploadJitterMs(), stats.getAvgUploadJitterMs()};
            this.logEvent(new InfluxDBEvent("channel_expired", RTP_CHANNEL_EXPIRED_COLUMNS, values));
        } else {
            Object[] values = new Object[]{channel.getID(), content.getName(), conference.getID(), endpointID};
            this.logEvent(new InfluxDBEvent("channel_expired", CHANNEL_EXPIRED_COLUMNS, values));
        }
    }

    public void handleEvent(Event event) {
        if (event == null) {
            logger.debug((Object)"Could not handle the event because it was null.");
            return;
        }
        String topic = event.getTopic();
        if ("org/jitsi/videobridge/Channel/CREATED".equals(topic)) {
            Channel channel = (Channel)((Object)event.getProperty("event.source"));
            this.channelCreated(channel);
        } else if ("org/jitsi/videobridge/Channel/EXPIRED".equals(topic)) {
            Channel channel = (Channel)((Object)event.getProperty("event.source"));
            this.channelExpired(channel);
        } else if ("org/jitsi/videobridge/Conference/CREATED".equals(topic)) {
            Conference conference = (Conference)event.getProperty("event.source");
            this.conferenceCreated(conference);
        } else if ("org/jitsi/videobridge/Conference/EXPIRED".equals(topic)) {
            Conference conference = (Conference)event.getProperty("event.source");
            this.conferenceExpired(conference);
        } else if ("org/jitsi/videobridge/Content/CREATED".equals(topic)) {
            Content content = (Content)event.getProperty("event.source");
            this.contentCreated(content);
        } else if ("org/jitsi/videobridge/Content/EXPIRED".equals(topic)) {
            Content content = (Content)event.getProperty("event.source");
            this.contentExpired(content);
        } else if ("org/jitsi/videobridge/Endpoint/CREATED".equals(topic)) {
            Endpoint endpoint = (Endpoint)event.getProperty("event.source");
            this.endpointCreated(endpoint);
        } else if ("org/jitsi/videobridge/Endpoint/NAME_CHANGED".equals(topic)) {
            Endpoint endpoint = (Endpoint)event.getProperty("event.source");
            this.endpointDisplayNameChanged(endpoint);
        } else if ("org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANNEL_ADDED".equals(topic)) {
            Channel channel = (Channel)((Object)event.getProperty("event.source"));
            this.transportChannelAdded(channel);
        } else if ("org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANNEL_REMOVED".equals(topic)) {
            Channel channel = (Channel)((Object)event.getProperty("event.source"));
            this.transportChannelRemoved(channel);
        } else if ("org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANNEL_CONNECTED".equals(topic)) {
            IceUdpTransportManager transportManager = (IceUdpTransportManager)event.getProperty("event.source");
            this.transportConnected(transportManager);
        } else if ("org/jitsi/videobridge/IceUdpTransportManager/CREATED".equals(topic)) {
            IceUdpTransportManager transportManager = (IceUdpTransportManager)event.getProperty("event.source");
            this.transportCreated(transportManager);
        } else if ("org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANGED".equals(topic)) {
            IceUdpTransportManager transportManager = (IceUdpTransportManager)event.getProperty("event.source");
            IceProcessingState oldState = (IceProcessingState)event.getProperty("oldState");
            IceProcessingState newState = (IceProcessingState)event.getProperty("newState");
            this.transportStateChanged(transportManager, oldState, newState);
        }
    }
}

