/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.ui.wizards;

import java.io.File;
import net.sf.fmj.ui.wizard.WizardPanelDescriptor;
import net.sf.fmj.ui.wizards.ContentAndTrackFormatPanelDescriptor;
import net.sf.fmj.ui.wizards.FileDestPanel;
import net.sf.fmj.ui.wizards.TranscodeWizardConfig;
import net.sf.fmj.ui.wizards.TranscodeWizardResult;
import net.sf.fmj.ui.wizards.WizardStepException;
import net.sf.fmj.utility.URLUtils;

public class FileDestPanelDescriptor
extends WizardPanelDescriptor {
    public static final String IDENTIFIER = FileDestPanelDescriptor.class.getName();
    private final TranscodeWizardResult result;
    private final TranscodeWizardConfig config;

    public FileDestPanelDescriptor(TranscodeWizardConfig transcodeWizardConfig, TranscodeWizardResult transcodeWizardResult) {
        super(IDENTIFIER, new FileDestPanel());
        this.config = transcodeWizardConfig;
        this.result = transcodeWizardResult;
    }

    public boolean aboutToDisplayPanel(Object object) {
        if (object == this.getBackPanelDescriptor()) {
            if (this.config.destUrl != null) {
                this.getFileDestPanel().getTextFile().setText(URLUtils.extractValidNewFilePathFromFileUrl(this.config.destUrl));
            }
            return true;
        }
        return super.aboutToDisplayPanel(object);
    }

    public boolean aboutToHidePanel(Object object) {
        if (object == this.getNextPanelDescriptor()) {
            String string = this.getFileDestPanel().getTextFile().getText();
            if (string == null || string.equals("")) {
                this.showError("Destination file path may not be blank");
                return false;
            }
            try {
                this.config.destUrl = URLUtils.createUrlStr(new File(string));
                this.result.step4_setDestUrlAndStart(this.config);
            }
            catch (WizardStepException wizardStepException) {
                this.showError(wizardStepException);
                return false;
            }
            return true;
        }
        return super.aboutToHidePanel(object);
    }

    public Object getBackPanelDescriptor() {
        return ContentAndTrackFormatPanelDescriptor.IDENTIFIER;
    }

    public FileDestPanel getFileDestPanel() {
        return (FileDestPanel)this.getPanelComponent();
    }

    public Object getNextPanelDescriptor() {
        return FINISH;
    }
}

