/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.util;

import java.awt.Component;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.Renderer;
import javax.media.ResourceUnavailableException;
import net.sf.fmj.filtergraph.SimpleGraphBuilder;
import net.sf.fmj.media.Log;

public class CodecChain {
    static final int STAGES = 5;
    protected Codec[] codecs = null;
    protected Buffer[] buffers = null;
    protected Format[] formats = null;
    protected Renderer renderer = null;
    private boolean deallocated = true;
    protected boolean firstBuffer = true;
    private boolean rtpFormat = false;

    protected boolean buildChain(Format format) {
        String string;
        Vector vector = new Vector(10);
        Vector vector2 = SimpleGraphBuilder.findRenderingChain(format, vector);
        if (vector2 == null) {
            return false;
        }
        int n = vector2.size();
        this.codecs = new Codec[n - 1];
        this.buffers = new Buffer[n - 1];
        this.formats = new Format[n];
        this.formats[0] = format;
        Log.comment("Monitor codec chain:");
        for (int i = 0; i < this.codecs.length; ++i) {
            this.codecs[i] = (Codec)vector2.elementAt(n - i - 1);
            this.formats[i + 1] = (Format)vector.elementAt(n - i - 2);
            this.buffers[i] = new Buffer();
            this.buffers[i].setFormat(this.formats[i + 1]);
            Log.write("    codec: " + this.codecs[i]);
            Log.write("      format: " + this.formats[i]);
        }
        this.renderer = (Renderer)vector2.elementAt(0);
        Log.write("    renderer: " + this.renderer);
        Log.write("      format: " + this.formats[this.codecs.length] + "\n");
        if (format.getEncoding() != null && (string = format.getEncoding().toUpperCase()).endsWith("RTP")) {
            this.rtpFormat = true;
        }
        return true;
    }

    public void close() {
        for (int i = 0; i < this.codecs.length; ++i) {
            this.codecs[i].close();
        }
        if (this.renderer != null) {
            this.renderer.close();
        }
    }

    public void deallocate() {
        if (this.deallocated) {
            return;
        }
        if (this.renderer != null) {
            this.renderer.close();
        }
        this.deallocated = true;
    }

    private int doProcess(int n, Buffer buffer, boolean bl) {
        int n2;
        Codec codec;
        Format format = buffer.getFormat();
        if (n == this.codecs.length) {
            if (bl) {
                if (this.renderer != null && this.formats[n] != null && this.formats[n] != format && !this.formats[n].equals(format) && !buffer.isDiscard()) {
                    if (this.renderer.setInputFormat(format) == null) {
                        Log.error("Monitor failed to handle mid-stream format change:");
                        Log.error("  old: " + this.formats[n]);
                        Log.error("  new: " + format);
                        return 1;
                    }
                    this.formats[n] = format;
                }
                try {
                    return this.renderer.process(buffer);
                }
                catch (Exception exception) {
                    Log.dumpStack(exception);
                    return 1;
                }
                catch (Error error) {
                    Log.dumpStack(error);
                    return 1;
                }
            }
            return 0;
        }
        if (this.isRawFormat(format)) {
            if (!bl) {
                return 0;
            }
        } else if (!this.rtpFormat && this.firstBuffer) {
            if ((buffer.getFlags() & 0x10) == 0) {
                return 0;
            }
            this.firstBuffer = false;
        }
        if ((codec = this.codecs[n]) != null && this.formats[n] != null && this.formats[n] != format && !this.formats[n].equals(format) && !buffer.isDiscard()) {
            if (codec.setInputFormat(format) == null) {
                Log.error("Monitor failed to handle mid-stream format change:");
                Log.error("  old: " + this.formats[n]);
                Log.error("  new: " + format);
                return 1;
            }
            this.formats[n] = format;
        }
        do {
            try {
                n2 = codec.process(buffer, this.buffers[n]);
            }
            catch (Exception exception) {
                Log.dumpStack(exception);
                return 1;
            }
            catch (Error error) {
                Log.dumpStack(error);
                return 1;
            }
            if (n2 == 1) {
                return 1;
            }
            if ((n2 & 4) != 0) continue;
            if (!this.buffers[n].isDiscard() && !this.buffers[n].isEOM()) {
                this.doProcess(n + 1, this.buffers[n], bl);
            }
            this.buffers[n].setOffset(0);
            this.buffers[n].setLength(0);
            this.buffers[n].setFlags(0);
        } while ((n2 & 2) != 0);
        return n2;
    }

    public Component getControlComponent() {
        return null;
    }

    boolean isRawFormat(Format format) {
        return false;
    }

    public boolean prefetch() {
        if (!this.deallocated) {
            return true;
        }
        try {
            this.renderer.open();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            return false;
        }
        this.renderer.start();
        this.deallocated = false;
        return true;
    }

    public int process(Buffer buffer, boolean bl) {
        int n = 0;
        return this.doProcess(n, buffer, bl);
    }

    public void reset() {
        this.firstBuffer = true;
        for (int i = 0; i < this.codecs.length; ++i) {
            if (this.codecs[i] == null) continue;
            this.codecs[i].reset();
        }
    }
}

