/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.media.GainChangeEvent;
import javax.media.GainChangeListener;
import javax.media.GainControl;

public abstract class AbstractGainControl
implements GainControl {
    private final List<GainChangeListener> listeners = new ArrayList<GainChangeListener>();
    private boolean mute;
    private float savedLevelDuringMute;

    protected static float dBToLevel(float f) {
        return (float)Math.pow(10.0, (double)f / 20.0);
    }

    protected static float levelToDb(float f) {
        return (float)(Math.log10(f) * 20.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGainChangeListener(GainChangeListener gainChangeListener) {
        List<GainChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(gainChangeListener);
        }
    }

    public Component getControlComponent() {
        return null;
    }

    public float getDB() {
        return AbstractGainControl.levelToDb(this.getLevel());
    }

    public boolean getMute() {
        return this.mute;
    }

    protected float getSavedLevelDuringMute() {
        return this.savedLevelDuringMute;
    }

    protected void notifyListenersGainChangeEvent() {
        GainChangeEvent gainChangeEvent = new GainChangeEvent(this, this.getMute(), this.getDB(), this.getLevel());
        this.notifyListenersGainChangeEvent(gainChangeEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersGainChangeEvent(GainChangeEvent gainChangeEvent) {
        ArrayList<GainChangeListener> arrayList = new ArrayList<GainChangeListener>();
        List<GainChangeListener> list = this.listeners;
        synchronized (list) {
            arrayList.addAll(this.listeners);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            GainChangeListener gainChangeListener = (GainChangeListener)arrayList.get(i);
            gainChangeListener.gainChange(gainChangeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGainChangeListener(GainChangeListener gainChangeListener) {
        List<GainChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(gainChangeListener);
        }
    }

    public float setDB(float f) {
        this.setLevel(AbstractGainControl.dBToLevel(f));
        float f2 = this.getDB();
        this.notifyListenersGainChangeEvent();
        return f2;
    }

    public void setMute(boolean bl) {
        if (bl == this.mute) {
            return;
        }
        if (bl) {
            this.savedLevelDuringMute = this.getLevel();
            this.setLevel(0.0f);
            this.mute = true;
        } else {
            this.setLevel(this.savedLevelDuringMute);
            this.mute = false;
        }
        this.notifyListenersGainChangeEvent();
    }
}

