/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import javax.media.Format;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFormat
extends Format {
    public static final int BIG_ENDIAN = 1;
    public static final int LITTLE_ENDIAN = 0;
    public static final int SIGNED = 1;
    public static final int UNSIGNED = 0;
    protected double sampleRate = -1.0;
    protected int sampleSizeInBits = -1;
    protected int channels = -1;
    protected int endian = -1;
    protected int signed = -1;
    protected double frameRate = -1.0;
    protected int frameSizeInBits = -1;
    public static final String LINEAR = "LINEAR";
    public static final String ULAW = "ULAW";
    public static final String ULAW_RTP = "ULAW/rtp";
    public static final String ALAW = "alaw";
    public static final String IMA4 = "ima4";
    public static final String IMA4_MS = "ima4/ms";
    public static final String MSADPCM = "msadpcm";
    public static final String DVI = "dvi";
    public static final String DVI_RTP = "dvi/rtp";
    public static final String G723 = "g723";
    public static final String G723_RTP = "g723/rtp";
    public static final String G728 = "g728";
    public static final String G728_RTP = "g728/rtp";
    public static final String G729 = "g729";
    public static final String G729_RTP = "g729/rtp";
    public static final String G729A = "g729a";
    public static final String G729A_RTP = "g729a/rtp";
    public static final String GSM = "gsm";
    public static final String GSM_MS = "gsm/ms";
    public static final String GSM_RTP = "gsm/rtp";
    public static final String MAC3 = "MAC3";
    public static final String MAC6 = "MAC6";
    public static final String TRUESPEECH = "truespeech";
    public static final String MSNAUDIO = "msnaudio";
    public static final String MPEGLAYER3 = "mpeglayer3";
    public static final String VOXWAREAC8 = "voxwareac8";
    public static final String VOXWAREAC10 = "voxwareac10";
    public static final String VOXWAREAC16 = "voxwareac16";
    public static final String VOXWAREAC20 = "voxwareac20";
    public static final String VOXWAREMETAVOICE = "voxwaremetavoice";
    public static final String VOXWAREMETASOUND = "voxwaremetasound";
    public static final String VOXWARERT29H = "voxwarert29h";
    public static final String VOXWAREVR12 = "voxwarevr12";
    public static final String VOXWAREVR18 = "voxwarevr18";
    public static final String VOXWARETQ40 = "voxwaretq40";
    public static final String VOXWARETQ60 = "voxwaretq60";
    public static final String MSRT24 = "msrt24";
    public static final String MPEG = "mpegaudio";
    public static final String MPEG_RTP = "mpegaudio/rtp";
    public static final String DOLBYAC3 = "dolbyac3";
    double multiplier = -1.0;
    int margin = 0;
    boolean init = false;

    public AudioFormat(String string) {
        super(string);
    }

    public AudioFormat(String string, double d, int n, int n2) {
        this(string);
        this.sampleRate = d;
        this.sampleSizeInBits = n;
        this.channels = n2;
    }

    public AudioFormat(String string, double d, int n, int n2, int n3, int n4) {
        this(string, d, n, n2);
        this.endian = n3;
        this.signed = n4;
    }

    public AudioFormat(String string, double d, int n, int n2, int n3, int n4, int n5, double d2, Class<?> clazz) {
        this(string, d, n, n2, n3, n4);
        this.frameSizeInBits = n5;
        this.frameRate = d2;
        this.dataType = clazz;
    }

    @Override
    public Object clone() {
        AudioFormat audioFormat = new AudioFormat(this.encoding);
        audioFormat.copy(this);
        return audioFormat;
    }

    public long computeDuration(long l) {
        if (this.init) {
            if (this.multiplier < 0.0) {
                return -1L;
            }
            return (long)((double)(l - (long)this.margin) * this.multiplier) * 1000L;
        }
        if (this.encoding == null) {
            this.init = true;
            return -1L;
        }
        if (this.encoding.equalsIgnoreCase(LINEAR) || this.encoding.equalsIgnoreCase(ULAW)) {
            if (this.sampleSizeInBits > 0 && this.channels > 0 && this.sampleRate > 0.0) {
                this.multiplier = (double)(8000000 / this.sampleSizeInBits / this.channels) / this.sampleRate;
            }
        } else if (this.encoding.equalsIgnoreCase(ULAW_RTP)) {
            if (this.sampleSizeInBits > 0 && this.channels > 0 && this.sampleRate > 0.0) {
                this.multiplier = (double)(8000000 / this.sampleSizeInBits / this.channels) / this.sampleRate;
            }
        } else if (this.encoding.equalsIgnoreCase(DVI_RTP)) {
            if (this.sampleSizeInBits > 0 && this.sampleRate > 0.0) {
                this.multiplier = (double)(8000000 / this.sampleSizeInBits) / this.sampleRate;
            }
            this.margin = 4;
        } else if (this.encoding.equalsIgnoreCase(GSM_RTP)) {
            if (this.sampleRate > 0.0) {
                this.multiplier = 4848484.0 / this.sampleRate;
            }
        } else if (this.encoding.equalsIgnoreCase(G723_RTP)) {
            if (this.sampleRate > 0.0) {
                this.multiplier = 1.0E7 / this.sampleRate;
            }
        } else if (this.frameSizeInBits != -1 && this.frameRate != -1.0 && this.frameSizeInBits > 0 && this.frameRate > 0.0) {
            this.multiplier = (double)(8000000 / this.frameSizeInBits) / this.frameRate;
        }
        this.init = true;
        if (this.multiplier > 0.0) {
            return (long)((double)(l - (long)this.margin) * this.multiplier) * 1000L;
        }
        return -1L;
    }

    @Override
    protected void copy(Format format) {
        super.copy(format);
        AudioFormat audioFormat = (AudioFormat)format;
        this.sampleRate = audioFormat.sampleRate;
        this.sampleSizeInBits = audioFormat.sampleSizeInBits;
        this.channels = audioFormat.channels;
        this.endian = audioFormat.endian;
        this.signed = audioFormat.signed;
        this.frameSizeInBits = audioFormat.frameSizeInBits;
        this.frameRate = audioFormat.frameRate;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof AudioFormat) {
            AudioFormat audioFormat = (AudioFormat)object;
            return super.equals(object) && this.sampleRate == audioFormat.sampleRate && this.sampleSizeInBits == audioFormat.sampleSizeInBits && this.channels == audioFormat.channels && this.endian == audioFormat.endian && this.signed == audioFormat.signed && this.frameSizeInBits == audioFormat.frameSizeInBits && this.frameRate == audioFormat.frameRate;
        }
        return false;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getEndian() {
        return this.endian;
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public int getFrameSizeInBits() {
        return this.frameSizeInBits;
    }

    public double getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getSigned() {
        return this.signed;
    }

    @Override
    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format2 == null) {
            return null;
        }
        if (!(format2 instanceof AudioFormat)) {
            return format2;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        AudioFormat audioFormat2 = (AudioFormat)format2;
        audioFormat2.sampleRate = this.sampleRate != -1.0 ? this.sampleRate : audioFormat.sampleRate;
        audioFormat2.sampleSizeInBits = this.sampleSizeInBits != -1 ? this.sampleSizeInBits : audioFormat.sampleSizeInBits;
        audioFormat2.channels = this.channels != -1 ? this.channels : audioFormat.channels;
        audioFormat2.endian = this.endian != -1 ? this.endian : audioFormat.endian;
        audioFormat2.signed = this.signed != -1 ? this.signed : audioFormat.signed;
        audioFormat2.frameSizeInBits = this.frameSizeInBits != -1 ? this.frameSizeInBits : audioFormat.frameSizeInBits;
        audioFormat2.frameRate = this.frameRate != -1.0 ? this.frameRate : audioFormat.frameRate;
        return audioFormat2;
    }

    @Override
    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof AudioFormat)) {
            return true;
        }
        AudioFormat audioFormat = (AudioFormat)format;
        return !(this.sampleRate != -1.0 && audioFormat.sampleRate != -1.0 && this.sampleRate != audioFormat.sampleRate || this.sampleSizeInBits != -1 && audioFormat.sampleSizeInBits != -1 && this.sampleSizeInBits != audioFormat.sampleSizeInBits || this.channels != -1 && audioFormat.channels != -1 && this.channels != audioFormat.channels || this.endian != -1 && audioFormat.endian != -1 && this.endian != audioFormat.endian || this.signed != -1 && audioFormat.signed != -1 && this.signed != audioFormat.signed || this.frameSizeInBits != -1 && audioFormat.frameSizeInBits != -1 && this.frameSizeInBits != audioFormat.frameSizeInBits || this.frameRate != -1.0 && audioFormat.frameRate != -1.0 && this.frameRate != audioFormat.frameRate);
    }

    @Override
    public String toString() {
        String string = "";
        String string2 = "";
        if (this.channels == 1) {
            string = ", Mono";
        } else if (this.channels == 2) {
            string = ", Stereo";
        } else if (this.channels != -1) {
            string = ", " + this.channels + "-channel";
        }
        if (this.sampleSizeInBits > 8) {
            if (this.endian == 1) {
                string2 = ", BigEndian";
            } else if (this.endian == 0) {
                string2 = ", LittleEndian";
            }
        }
        return this.getEncoding() + (this.sampleRate != -1.0 ? ", " + this.sampleRate + " Hz" : ", Unknown Sample Rate") + (this.sampleSizeInBits != -1 ? ", " + this.sampleSizeInBits + "-bit" : "") + string + string2 + (this.signed != -1 ? (this.signed == 1 ? ", Signed" : ", Unsigned") : "") + (this.frameRate != -1.0 ? ", " + this.frameRate + " frame rate" : "") + (this.frameSizeInBits != -1 ? ", FrameSize=" + this.frameSizeInBits + " bits" : "") + (this.dataType != Format.byteArray && this.dataType != null ? ", " + this.dataType : "");
    }
}

