/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.configuration;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.jitsi.service.configuration.ConfigVetoableChangeListener;

public class ChangeEventDispatcher {
    private List<PropertyChangeListener> propertyChangeListeners;
    private List<ConfigVetoableChangeListener> vetoableChangeListeners;
    private Map<String, ChangeEventDispatcher> propertyChangeChildren;
    private Map<String, ChangeEventDispatcher> vetoableChangeChildren;
    private final Object source;

    public ChangeEventDispatcher(Object sourceObject) {
        if (sourceObject == null) {
            throw new NullPointerException("sourceObject");
        }
        this.source = sourceObject;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new Vector<PropertyChangeListener>();
        }
        this.propertyChangeListeners.add(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        ChangeEventDispatcher child;
        if (this.propertyChangeChildren == null) {
            this.propertyChangeChildren = new Hashtable<String, ChangeEventDispatcher>();
        }
        if ((child = this.propertyChangeChildren.get(propertyName)) == null) {
            child = new ChangeEventDispatcher(this.source);
            this.propertyChangeChildren.put(propertyName, child);
        }
        child.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeListeners != null) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        ChangeEventDispatcher child;
        if (this.propertyChangeChildren != null && (child = this.propertyChangeChildren.get(propertyName)) != null) {
            child.removePropertyChangeListener(listener);
        }
    }

    public synchronized void addVetoableChangeListener(ConfigVetoableChangeListener listener) {
        if (this.vetoableChangeListeners == null) {
            this.vetoableChangeListeners = new Vector<ConfigVetoableChangeListener>();
        }
        this.vetoableChangeListeners.add(listener);
    }

    public synchronized void removeVetoableChangeListener(ConfigVetoableChangeListener listener) {
        if (this.vetoableChangeListeners != null) {
            this.vetoableChangeListeners.remove(listener);
        }
    }

    public synchronized void addVetoableChangeListener(String propertyName, ConfigVetoableChangeListener listener) {
        ChangeEventDispatcher child;
        if (this.vetoableChangeChildren == null) {
            this.vetoableChangeChildren = new Hashtable<String, ChangeEventDispatcher>();
        }
        if ((child = this.vetoableChangeChildren.get(propertyName)) == null) {
            child = new ChangeEventDispatcher(this.source);
            this.vetoableChangeChildren.put(propertyName, child);
        }
        child.addVetoableChangeListener(listener);
    }

    public synchronized void removeVetoableChangeListener(String propertyName, ConfigVetoableChangeListener listener) {
        ChangeEventDispatcher child;
        if (this.vetoableChangeChildren != null && (child = this.vetoableChangeChildren.get(propertyName)) != null) {
            child.removeVetoableChangeListener(listener);
        }
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) {
        if (this.vetoableChangeListeners != null || this.vetoableChangeChildren != null) {
            this.fireVetoableChange(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVetoableChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        String propertyName = evt.getPropertyName();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        ConfigVetoableChangeListener[] targets = null;
        ChangeEventDispatcher child = null;
        ConfigVetoableChangeListener[] configVetoableChangeListenerArray = this;
        synchronized (this) {
            if (this.vetoableChangeListeners != null) {
                targets = this.vetoableChangeListeners.toArray(new ConfigVetoableChangeListener[this.vetoableChangeListeners.size()]);
            }
            if (this.vetoableChangeChildren != null && propertyName != null) {
                child = this.vetoableChangeChildren.get(propertyName);
            }
            // ** MonitorExit[var7_7] (shouldn't be in output)
            if (this.vetoableChangeListeners != null && targets != null) {
                for (ConfigVetoableChangeListener target : targets) {
                    target.vetoableChange(evt);
                }
            }
            if (child != null) {
                child.fireVetoableChange(evt);
            }
            return;
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.firePropertyChange(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
        }
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        ChangeEventDispatcher child;
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        String propertyName = evt.getPropertyName();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        if (this.propertyChangeListeners != null) {
            for (PropertyChangeListener target : this.propertyChangeListeners) {
                target.propertyChange(evt);
            }
        }
        if (this.propertyChangeChildren != null && propertyName != null && (child = this.propertyChangeChildren.get(propertyName)) != null) {
            child.firePropertyChange(evt);
        }
    }

    public synchronized boolean hasPropertyChangeListeners(String propertyName) {
        ChangeEventDispatcher child;
        if (this.propertyChangeListeners != null && !this.propertyChangeListeners.isEmpty()) {
            return true;
        }
        if (this.propertyChangeChildren != null && (child = this.propertyChangeChildren.get(propertyName)) != null && child.propertyChangeListeners != null) {
            return !child.propertyChangeListeners.isEmpty();
        }
        return false;
    }

    public synchronized boolean hasVetoableChangeListeners(String propertyName) {
        ChangeEventDispatcher child;
        if (this.vetoableChangeListeners != null && !this.vetoableChangeListeners.isEmpty()) {
            return true;
        }
        if (this.vetoableChangeChildren != null && (child = this.vetoableChangeChildren.get(propertyName)) != null && child.vetoableChangeListeners != null) {
            return !child.vetoableChangeListeners.isEmpty();
        }
        return false;
    }
}

