/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.address;

import gov.nist.core.HostPort;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.NetObject;
import gov.nist.javax.sip.address.SipUri;
import javax.sip.address.Address;
import javax.sip.address.URI;

public final class AddressImpl
extends NetObject
implements Address {
    public static final int NAME_ADDR = 1;
    public static final int ADDRESS_SPEC = 2;
    public static final int WILD_CARD = 3;
    protected int addressType = 1;
    protected String displayName;
    protected GenericURI address;

    public boolean match(Object object) {
        if (object == null) {
            return true;
        }
        if (!(object instanceof Address)) {
            return false;
        }
        AddressImpl addressImpl = (AddressImpl)object;
        if (addressImpl.getMatcher() != null) {
            return addressImpl.getMatcher().match(this.encode());
        }
        if (addressImpl.displayName != null && this.displayName == null) {
            return false;
        }
        if (addressImpl.displayName == null) {
            return this.address.match(addressImpl.address);
        }
        return this.displayName.equalsIgnoreCase(addressImpl.displayName) && this.address.match(addressImpl.address);
    }

    public HostPort getHostPort() {
        if (!(this.address instanceof SipUri)) {
            throw new RuntimeException("address is not a SipUri");
        }
        SipUri sipUri = (SipUri)this.address;
        return sipUri.getHostPort();
    }

    public int getPort() {
        if (!(this.address instanceof SipUri)) {
            throw new RuntimeException("address is not a SipUri");
        }
        SipUri sipUri = (SipUri)this.address;
        return sipUri.getHostPort().getPort();
    }

    public String getUserAtHostPort() {
        if (this.address instanceof SipUri) {
            SipUri sipUri = (SipUri)this.address;
            return sipUri.getUserAtHostPort();
        }
        return this.address.toString();
    }

    public String getHost() {
        if (!(this.address instanceof SipUri)) {
            throw new RuntimeException("address is not a SipUri");
        }
        SipUri sipUri = (SipUri)this.address;
        return sipUri.getHostPort().getHost().getHostname();
    }

    public void removeParameter(String string) {
        if (!(this.address instanceof SipUri)) {
            throw new RuntimeException("address is not a SipUri");
        }
        SipUri sipUri = (SipUri)this.address;
        sipUri.removeParameter(string);
    }

    public String encode() {
        return this.encode(new StringBuffer()).toString();
    }

    public StringBuffer encode(StringBuffer stringBuffer) {
        if (this.addressType == 3) {
            stringBuffer.append('*');
        } else {
            if (this.displayName != null) {
                stringBuffer.append("\"").append(this.displayName).append("\"").append(" ");
            }
            if (this.address != null) {
                if (this.addressType == 1 || this.displayName != null) {
                    stringBuffer.append("<");
                }
                this.address.encode(stringBuffer);
                if (this.addressType == 1 || this.displayName != null) {
                    stringBuffer.append(">");
                }
            }
        }
        return stringBuffer;
    }

    public int getAddressType() {
        return this.addressType;
    }

    public void setAddressType(int n) {
        this.addressType = n;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
        this.addressType = 1;
    }

    public void setAddess(URI uRI) {
        this.address = (GenericURI)uRI;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Address) {
            Address address = (Address)object;
            return this.getURI().equals(address.getURI());
        }
        return false;
    }

    public boolean hasDisplayName() {
        return this.displayName != null;
    }

    public void removeDisplayName() {
        this.displayName = null;
    }

    public boolean isSIPAddress() {
        return this.address instanceof SipUri;
    }

    public URI getURI() {
        return this.address;
    }

    public boolean isWildcard() {
        return this.addressType == 3;
    }

    public void setURI(URI uRI) {
        this.address = (GenericURI)uRI;
    }

    public void setUser(String string) {
        ((SipUri)this.address).setUser(string);
    }

    public void setWildCardFlag() {
        this.addressType = 3;
        this.address = new SipUri();
        ((SipUri)this.address).setUser("*");
    }

    public Object clone() {
        AddressImpl addressImpl = (AddressImpl)super.clone();
        if (this.address != null) {
            addressImpl.address = (GenericURI)this.address.clone();
        }
        return addressImpl;
    }
}

