/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.extensions.colibri.ColibriConferenceIQ;
import org.jitsi.util.Logger;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.Videobridge;
import org.osgi.framework.BundleContext;

public class Conference {
    private static final Logger logger = Logger.getLogger(Conference.class);
    private final List<Content> contents = new LinkedList<Content>();
    private final List<WeakReference<Endpoint>> endpoints = new LinkedList<WeakReference<Endpoint>>();
    private boolean expired = false;
    private final String focus;
    private final String id;
    private long lastActivityTime;
    private final Videobridge videobridge;

    private static void logd(String s) {
        logger.info((Object)s);
    }

    public Conference(Videobridge videobridge, String id, String focus) {
        if (videobridge == null) {
            throw new NullPointerException("videoBridge");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (focus == null) {
            throw new NullPointerException("focus");
        }
        this.videobridge = videobridge;
        this.id = id;
        this.focus = focus;
    }

    public void describe(ColibriConferenceIQ iq) {
        iq.setID(this.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        Conference conference = this;
        synchronized (conference) {
            if (this.expired) {
                return;
            }
            this.expired = true;
        }
        Videobridge videobridge = this.getVideobridge();
        try {
            videobridge.expireConference(this);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            for (Content content : this.getContents()) {
                try {
                    content.expire();
                }
                catch (Throwable t) {
                    logger.warn((Object)("Failed to expire content " + content.getName() + " of conference " + this.getID() + "!"), t);
                    if (!(t instanceof ThreadDeath)) continue;
                    throw (ThreadDeath)t;
                }
            }
            Conference.logd("Expired conference " + this.getID() + ". The total number of" + " conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
            throw throwable;
        }
        for (Content content : this.getContents()) {
            try {
                content.expire();
            }
            catch (Throwable t) {
                logger.warn((Object)("Failed to expire content " + content.getName() + " of conference " + this.getID() + "!"), t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        {
        }
        Conference.logd("Expired conference " + this.getID() + ". The total number of" + " conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireContent(Content content) {
        boolean expireContent;
        List<Content> list = this.contents;
        synchronized (list) {
            if (this.contents.contains(content)) {
                this.contents.remove(content);
                expireContent = true;
            } else {
                expireContent = false;
            }
        }
        if (expireContent) {
            content.expire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content[] getContents() {
        List<Content> list = this.contents;
        synchronized (list) {
            return this.contents.toArray(new Content[this.contents.size()]);
        }
    }

    public final String getFocus() {
        return this.focus;
    }

    public final String getID() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastActivityTime() {
        Conference conference = this;
        synchronized (conference) {
            return this.lastActivityTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Content getOrCreateContent(String name) {
        Content content;
        List<Content> list = this.contents;
        synchronized (list) {
            for (Content aContent : this.contents) {
                if (!aContent.getName().equals(name)) continue;
                aContent.touch();
                return aContent;
            }
            content = new Content(this, name);
            this.contents.add(content);
        }
        Videobridge videobridge = this.getVideobridge();
        Conference.logd("Created content " + name + " of conference " + this.getID() + ". The total number of conferences is now " + videobridge.getConferenceCount() + ", channels " + videobridge.getChannelCount() + ".");
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getOrCreateEndpoint(String id) {
        List<WeakReference<Endpoint>> list = this.endpoints;
        synchronized (list) {
            Iterator<WeakReference<Endpoint>> i = this.endpoints.iterator();
            while (i.hasNext()) {
                Endpoint endpoint = (Endpoint)i.next().get();
                if (endpoint == null) {
                    i.remove();
                    continue;
                }
                if (!endpoint.getID().equals(id)) continue;
                return endpoint;
            }
            Endpoint endpoint = new Endpoint(id);
            this.endpoints.add(new WeakReference<Endpoint>(endpoint));
            return endpoint;
        }
    }

    public final Videobridge getVideobridge() {
        return this.videobridge;
    }

    public BundleContext getBundleContext() {
        return this.getVideobridge().getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch() {
        long now = System.currentTimeMillis();
        Conference conference = this;
        synchronized (conference) {
            if (this.getLastActivityTime() < now) {
                this.lastActivityTime = now;
            }
        }
    }
}

