/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol.file;

import com.lti.utils.PathUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.Seekable;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.media.MimeManager;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class DataSource
extends PullDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    protected RandomAccessFile raf;
    protected boolean connected = false;
    protected ContentDescriptor contentType;
    protected RAFPullSourceStream[] sources;
    private long contentLength = -1L;

    private static String getContentTypeFor(String path) {
        String ext = PathUtils.extractExtension(path);
        String result = MimeManager.getMimeType(ext);
        if (result != null) {
            return result;
        }
        result = URLConnection.getFileNameMap().getContentTypeFor(path);
        return result;
    }

    public void connect() throws IOException {
        try {
            String path = URLUtils.extractValidPathFromFileUrl(this.getLocator().toExternalForm());
            if (path == null) {
                throw new IOException("Cannot determine valid file path from URL: " + this.getLocator().toExternalForm());
            }
            this.raf = new RandomAccessFile(path, "r");
            this.contentLength = this.raf.length();
            String s = DataSource.getContentTypeFor(path);
            if (s == null) {
                throw new IOException("Unknown content type for path: " + path);
            }
            this.contentType = new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(s));
            this.sources = new RAFPullSourceStream[1];
            this.sources[0] = new RAFPullSourceStream();
            this.connected = true;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "" + e, e);
            throw e;
        }
    }

    public javax.media.protocol.DataSource createClone() {
        DataSource d = new DataSource();
        d.setLocator(this.getLocator());
        if (this.connected) {
            try {
                d.connect();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                return null;
            }
        }
        return d;
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
    }

    public String getContentType() {
        if (!this.connected) {
            throw new Error("Source is unconnected.");
        }
        String path = this.getLocator().getRemainder();
        String s = DataSource.getContentTypeFor(path);
        return ContentDescriptor.mimeTypeToPackageName(s);
    }

    public Object getControl(String controlName) {
        return null;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Time getDuration() {
        return Time.TIME_UNKNOWN;
    }

    public PullSourceStream[] getStreams() {
        if (!this.connected) {
            throw new Error("Unconnected source.");
        }
        return this.sources;
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    class RAFPullSourceStream
    implements PullSourceStream,
    Seekable {
        private boolean endOfStream = false;

        RAFPullSourceStream() {
        }

        public boolean endOfStream() {
            return this.endOfStream;
        }

        public ContentDescriptor getContentDescriptor() {
            return DataSource.this.contentType;
        }

        public long getContentLength() {
            return DataSource.this.contentLength;
        }

        public Object getControl(String controlType) {
            return null;
        }

        public Object[] getControls() {
            return new Object[0];
        }

        public boolean isRandomAccess() {
            return true;
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            int result = DataSource.this.raf.read(buffer, offset, length);
            if (result == -1) {
                this.endOfStream = true;
            }
            return result;
        }

        public long seek(long where) {
            try {
                DataSource.this.raf.seek(where);
                return DataSource.this.raf.getFilePointer();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new RuntimeException(e);
            }
        }

        public long tell() {
            try {
                return DataSource.this.raf.getFilePointer();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                throw new RuntimeException(e);
            }
        }

        public boolean willReadBlock() {
            return false;
        }
    }
}

