/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.neomedia.codec.audio.g722;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;
import net.java.sip.communicator.impl.neomedia.codec.audio.g722.JNIDecoder;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;

public class JNIEncoder
extends AbstractCodec2 {
    private long encoder;

    private static native void g722_encoder_close(long var0);

    private static native long g722_encoder_open();

    private static native void g722_encoder_process(long var0, byte[] var2, int var3, byte[] var4, int var5, int var6);

    public JNIEncoder() {
        super("G.722 JNI Encoder", AudioFormat.class, JNIDecoder.SUPPORTED_INPUT_FORMATS);
        this.inputFormats = JNIDecoder.SUPPORTED_OUTPUT_FORMATS;
    }

    private long computeDuration(long length) {
        return length * 1000000L / 8L;
    }

    @Override
    protected void doClose() {
        JNIEncoder.g722_encoder_close(this.encoder);
    }

    @Override
    protected void doOpen() throws ResourceUnavailableException {
        this.encoder = JNIEncoder.g722_encoder_open();
        if (this.encoder == 0L) {
            throw new ResourceUnavailableException("g722_encoder_open");
        }
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int inputOffset = inputBuffer.getOffset();
        int inputLength = inputBuffer.getLength();
        byte[] input = (byte[])inputBuffer.getData();
        int outputOffset = outputBuffer.getOffset();
        int outputLength = inputLength / 4;
        byte[] output = JNIEncoder.validateByteArraySize(outputBuffer, outputOffset + outputLength, true);
        JNIEncoder.g722_encoder_process(this.encoder, input, inputOffset, output, outputOffset, outputLength);
        outputBuffer.setDuration(this.computeDuration(outputLength));
        outputBuffer.setFormat(this.getOutputFormat());
        outputBuffer.setLength(outputLength);
        return 0;
    }

    @Override
    public Format getOutputFormat() {
        Format outputFormat = super.getOutputFormat();
        if (outputFormat != null && outputFormat.getClass() == AudioFormat.class) {
            AudioFormat outputAudioFormat = (AudioFormat)outputFormat;
            this.setOutputFormat(new AudioFormat(outputAudioFormat.getEncoding(), outputAudioFormat.getSampleRate(), outputAudioFormat.getSampleSizeInBits(), outputAudioFormat.getChannels(), outputAudioFormat.getEndian(), outputAudioFormat.getSigned(), outputAudioFormat.getFrameSizeInBits(), outputAudioFormat.getFrameRate(), outputAudioFormat.getDataType()){
                private static final long serialVersionUID = 0L;

                @Override
                public long computeDuration(long length) {
                    return JNIEncoder.this.computeDuration(length);
                }
            });
        }
        return outputFormat;
    }

    static {
        System.loadLibrary("jng722");
    }
}

