/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.data;

import com.voxeo.data.Schema;
import com.voxeo.data.ScriptType;
import com.voxeo.utils.Exceptions;
import java.io.File;

public class Script {
    private static final String SCRIPT_SEPARATOR = "_";
    private File file;
    private Integer version;
    private String schemaName;
    private ScriptType type;
    private Schema schema;

    public Script(File scriptFile) {
        int typeIndex;
        this.file = scriptFile;
        String fileName = scriptFile.getName();
        int extStart = fileName.lastIndexOf(46);
        if (extStart != -1) {
            fileName = fileName.substring(0, extStart);
        }
        if ((typeIndex = fileName.indexOf(SCRIPT_SEPARATOR)) == -1) {
            this.handleInvalidScriptName(fileName);
        }
        String typeString = fileName.substring(0, typeIndex);
        this.type = ScriptType.valueOf(typeString.toUpperCase());
        int versionIndex = fileName.lastIndexOf(SCRIPT_SEPARATOR);
        if (versionIndex == -1 || versionIndex == typeIndex) {
            this.handleInvalidScriptName(fileName);
        }
        this.version = new Integer(fileName.substring(versionIndex + 1, fileName.length()));
        if (versionIndex - typeIndex == 0) {
            this.handleInvalidScriptName(fileName);
        }
        this.schemaName = fileName.substring(typeIndex + 1, versionIndex);
    }

    private void handleInvalidScriptName(String fileName) {
        Exceptions.fling(IllegalArgumentException.class, "Script name is invalid [value=%s]", fileName);
    }

    public File getFile() {
        return this.file;
    }

    String getSchemaName() {
        return this.schemaName;
    }

    public Integer getVersion() {
        return this.version;
    }

    public ScriptType getType() {
        return this.type;
    }

    public Schema getSchema() {
        return this.schema;
    }
}

