/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public class VisibilityItem
extends AbstractItemObj {
    public static final long MASK_SHOW_IDLE_TIME = 1024L;
    public static final long MASK_SHOW_TYPING = 0x400000L;
    private static final int TYPE_VIS_MASK = 201;
    private static final String NAME_DEFAULT = "";
    private static final int GROUPID_DEFAULT = 0;
    private final int id;
    private long flags;

    public VisibilityItem(SsiItem ssiItem) {
        DefensiveTools.checkNull(ssiItem, "item");
        this.id = ssiItem.getId();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(ssiItem.getData());
        Tlv tlv = immutableTlvChain.getLastTlv(201);
        if (tlv != null) {
            this.flags = tlv.getDataAsUInt();
            if (this.flags == -1L) {
                this.flags = 0L;
            }
        } else {
            this.flags = 0L;
        }
        MutableTlvChain mutableTlvChain = TlvTools.getMutableCopy(immutableTlvChain);
        mutableTlvChain.removeTlvs(new int[]{201});
        this.addExtraTlvs(mutableTlvChain);
    }

    public VisibilityItem(VisibilityItem visibilityItem) {
        this(visibilityItem.id, visibilityItem.flags, visibilityItem.copyExtraTlvs());
    }

    public VisibilityItem(int n, long l) {
        this(n, l, null);
    }

    public VisibilityItem(int n, long l, TlvChain tlvChain) {
        super(tlvChain);
        DefensiveTools.checkRange(n, "id", 0);
        DefensiveTools.checkRange(l, "flags", 0);
        this.id = n;
        this.flags = l;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized long getVisFlags() {
        return this.flags;
    }

    public final synchronized void setVisFlags(long l) {
        this.flags = l;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain mutableTlvChain = TlvTools.createMutableChain();
        if (this.flags != 0L) {
            byte[] byArray = BinaryTools.getUInt(this.flags);
            ByteBlock byteBlock = ByteBlock.wrap(byArray);
            mutableTlvChain.addTlv(new Tlv(201, byteBlock));
        }
        return this.generateItem(NAME_DEFAULT, 0, this.id, 5, mutableTlvChain);
    }

    public synchronized String toString() {
        return "VisibilityItem: id=0x" + Integer.toHexString(this.id) + ", flags=0x" + Long.toHexString(this.flags);
    }
}

