/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.net;

import java.net.InetAddress;
import net.kano.joscar.DefensiveTools;

public class ConnDescriptor {
    private final String host;
    private final InetAddress address;
    private final int port;

    public ConnDescriptor(String string, int n) {
        DefensiveTools.checkNull(string, "host");
        DefensiveTools.checkRange(n, "port", 0);
        this.host = string;
        this.address = null;
        this.port = n;
    }

    public ConnDescriptor(InetAddress inetAddress, int n) {
        DefensiveTools.checkNull(inetAddress, "address");
        DefensiveTools.checkRange(n, "port", 0);
        this.host = null;
        this.address = inetAddress;
        this.port = n;
    }

    public final String getHost() {
        return this.host;
    }

    public final InetAddress getAddress() {
        return this.address;
    }

    public final int getPort() {
        return this.port;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConnDescriptor)) {
            return false;
        }
        ConnDescriptor connDescriptor = (ConnDescriptor)object;
        if (this.port != connDescriptor.port) {
            return false;
        }
        if (this.address != null ? !this.address.equals(connDescriptor.address) : connDescriptor.address != null) {
            return false;
        }
        return !(this.host != null ? !this.host.equals(connDescriptor.host) : connDescriptor.host != null);
    }

    public int hashCode() {
        int n = this.host != null ? this.host.hashCode() : 0;
        n = 29 * n + (this.address != null ? this.address.hashCode() : 0);
        n = 29 * n + this.port;
        return n;
    }

    public String toString() {
        Object object = this.host == null ? this.address : this.host;
        return "ConnDescriptor: " + object + ":" + this.port;
    }
}

